<?php

require 'vendor/autoload.php';

use Espo\ApiClient\Client;
use Espo\ApiClient\Header;

// update this with your CRM domain
$client = new Client('https://your-domain.com');
// create an API user and assign it a role with access (create document) and add the API key here
$client->setApiKey('your-api-key');

// Initialize progress variables
$progressTotal = 0;
$progressCurrent = 0;
$error = '';

if (isset($_POST['submit'])) {

    $mainDirectory = $_POST['filePath'];

    // Validate the filePath field
    if (empty($mainDirectory)) {
        $error = "Please enter the full path to your files";
    } else {
        // Check if the filePath is a valid full path
        if (!is_dir($mainDirectory)) {
            $error = "Invalid directory path";
        }
    }

    $documentFoldersResponse = $client->request(Client::METHOD_GET, 'DocumentFolder', [
        'select' => 'id,name',
        'orderBy' => 'createdAt',
        'order' => 'desc',
    ]);

    $documentFolderResponseBody = $documentFoldersResponse->getParsedBody();

    $foldersData = array_reduce($documentFolderResponseBody->list, fn ($carry, $folder) => array_merge($carry, [$folder->name => ['id' => $folder->id, 'name' => $folder->name]]), []);

    $documentsResponse = $client->request(Client::METHOD_GET, 'Document', [
        'select' => 'id,name,fileId,fileName',
        'orderBy' => 'createdAt',
        'order' => 'desc',
    ]);

    $documentResponseBody = $documentsResponse->getParsedBody();

    $filesData = array_reduce($documentResponseBody->list, fn ($carry, $document) => array_merge($carry, [$document->fileName => ['file_id' => $document->fileId, 'file_name' => $document->fileName]]), []);

    // Get the list of subdirectories in the main directory
    $subdirectories = array_diff(scandir($mainDirectory), ['.', '..']);

    // Loop through the subdirectories
    foreach ($subdirectories as $subdirectory) {
        $subdirectoryPath = $mainDirectory . '/' . $subdirectory;

        // Check if the subdirectory is a directory
        if (is_dir($subdirectoryPath) && !isset($foldersData[$subdirectory])) {
            try {
                // Create document folder record
                $documentFolderResponse = $client->request(
                    Client::METHOD_POST,
                    'DocumentFolder',
                    [
                        'name' => $subdirectory,
                    ],
                    [new Header('Content-Type', 'application/json')]
                );

                // Check if the response was successful
                if ($documentFolderResponse->getParsedBody()->id) {
                    // Document folder created successfully
                    $documentFolderId = $documentFolderResponse->getParsedBody()->id;

                    $files = array_diff(scandir($subdirectoryPath), ['.', '..']);
                    $totalFiles = count($files);
                    $count = 0;

                    foreach ($files as $file) {
                        $filePath = $subdirectoryPath . '/' . $file;

                        if (isset($filesData[basename($file)])) {
                            continue;
                        }

                        if (is_file($filePath) && !startsWithDot($file)) {
                            $name = basename($file);
                            $type = mime_content_type($filePath);
                            $size = filesize($filePath);
                            $fileContents = file_get_contents($filePath);
                            $base64EncodedContent = 'data:' . $type . ';base64,' . base64_encode($fileContents);

                            try {
                                // Create attachment record
                                $response = $client->request(
                                    Client::METHOD_POST,
                                    'Attachment',
                                    [
                                        'name' => $name,
                                        'type' => $type,
                                        'role' => 'Attachment',
                                        'relatedType' => 'Document',
                                        'size' => $size,
                                        'field' => 'file',
                                        'file' => $base64EncodedContent,
                                    ],
                                    [new Header('Content-Type', 'application/json')]
                                );

                                // Check if the response was successful
                                if ($response->getParsedBody()->id) {
                                    // Attachment created successfully
                                    $attachmentId = $response->getParsedBody()->id;

                                    try {
                                        // Create document record
                                        $response = $client->request(
                                            Client::METHOD_POST,
                                            'Document',
                                            [
                                                'name' => $name,
                                                'fileId' => $attachmentId,
                                                'folderId' => $documentFolderId,
                                                'publishDate' => date("Y-m-d"),
                                            ],
                                            [new Header('Content-Type', 'application/json')]
                                        );
                                    } catch (Espo\ApiClient\Exception\ResponseError $e) {
                                        // Handle the exception
                                        echo 'Error Creating Document record: ' . $e->getCode();
                                    }
                                } else {
                                    // Handle the error case for attachment creation
                                    echo 'Error creating attachment: ' . $response->getCode();
                                }
                            } catch (Espo\ApiClient\Exception\ResponseError $e) {
                                // Handle the exception
                                echo 'Error: ' . $e->getCode();
                            }

                            // Update progress variables
                            $count++;
                            $progressTotal = $totalFiles;
                            $progressCurrent = $count;
                            flush();
                        }
                    }
                } else {
                    // Handle the error case for document folder creation
                    echo 'Error creating document folder: ' . $documentFolderResponse->getCode();
                }
            } catch (Espo\ApiClient\Exception\ResponseError $e) {
                // Handle the exception
                echo 'Error: ' . $e->getCode();
            }
        } elseif (is_dir($subdirectoryPath) && isset($foldersData[$subdirectory])) {
            $files = array_diff(scandir($subdirectoryPath), ['.', '..']);
            $totalFiles = count($files);
            $count = 0;

            foreach ($files as $file) {
                $filePath = $subdirectoryPath . '/' . $file;

                if (isset($filesData[basename($file)])) {
                    continue;
                }

                if (is_file($filePath) && !startsWithDot($file)) {
                    $name = basename($file);
                    $type = mime_content_type($filePath);
                    $size = filesize($filePath);
                    $fileContents = file_get_contents($filePath);
                    $base64EncodedContent = 'data:' . $type . ';base64,' . base64_encode($fileContents);

                    // Create attachment record
                    $response = $client->request(
                        Client::METHOD_POST,
                        'Attachment',
                        [
                            'name' => $name,
                            'type' => $type,
                            'role' => 'Attachment',
                            'relatedType' => 'Document',
                            'size' => $size,
                            'field' => 'file',
                            'file' => $base64EncodedContent,
                        ],
                        [new Header('Content-Type', 'application/json')]
                    );

                    // Check if the response was successful
                    if ($response->getParsedBody()->id) {
                        // Attachment created successfully
                        $attachmentId = $response->getParsedBody()->id;

                        try {
                            // Create document record
                            $response = $client->request(
                                Client::METHOD_POST,
                                'Document',
                                [
                                    'name' => $name,
                                    'fileId' => $attachmentId,
                                    'folderId' => $foldersData[$subdirectory]['id'],
                                    'publishDate' => date("Y-m-d"),
                                ],
                                [new Header('Content-Type', 'application/json')]
                            );
                        } catch (Espo\ApiClient\Exception\ResponseError $e) {
                            // Handle the exception
                            echo 'Error Creating Document record: ' . $e->getCode();
                        }
                    }

                    // Update progress variables
                    $count++;
                    $progressTotal = $totalFiles;
                    $progressCurrent = $count;
                    flush();
                }
            }
        }
    }
}

function startsWithDot($str)
{
    return substr($str, 0, 1) === '.';
}

function progressBar($progressTotal, $progressCurrent)
{
    $percentComplete = $progressTotal > 0 ? intval(($progressCurrent / $progressTotal) * 100) : 0;
    $barWidth = 400;
    $fillWidth = intval(($percentComplete / 100) * $barWidth);
    $barText = $percentComplete . '%';

    echo '<div class="progress-bar">';
    echo '<div class="progress-bar-fill" style="width: ' . $fillWidth . 'px;"></div>';
    echo '</div>';
    echo '<p class="progress-bar-text">' . $barText . '</p>';
}

?>

 <!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Attachment Uploader</title>
  <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.17/dist/tailwind.min.css" rel="stylesheet">
  <style>
    .progress-bar {
      width: 100%;
      background-color: #f2f2f2;
      border-radius: 4px;
      overflow: hidden;
      height: 10px;
    }
    .progress-bar-fill {
      background-color: #10b981;
      height: 100%;
      transition: width 0.3s ease-in-out;
    }
    .progress-bar-text {
      margin-top: 8px;
      font-size: 14px;
      font-weight: bold;
      text-align: center;
    }
  </style>
</head>

<body class="p-8">
  <div class="max-w-sm mx-auto">
    <h1 class="text-2xl font-bold mb-4">Espo API File Uploader</h1>
    <?php if (!empty($error)) : ?>
      <div class="bg-red-100 text-red-700 py-2 px-4 mb-4 rounded">
        <?php echo $error; ?>
      </div>
    <?php endif; ?>
    <form action="" method="POST" class="mb-6">
      <div class="mb-4">
        <label for="filePath" class="block mb-2">Full Files' Directory Path</label>
        <input type="text" id="filePath" name="filePath" placeholder="Enter the full path to your files"
          class="w-full px-4 py-2 border rounded focus:outline-none focus:border-blue-400">
      </div>
      <button type="submit" name="submit"
        class="w-full bg-blue-500 text-white font-bold py-2 px-4 rounded hover:bg-blue-600 transition duration-200">Start
        Uploading Files
      </button>
    </form>
    <?php
      progressBar($progressTotal, $progressCurrent);
    ?>
  </div>
  <script>
    function updateProgress(progressTotal, progressCurrent) {
      var percentComplete = progressTotal > 0 ? Math.floor((progressCurrent / progressTotal) * 100) : 0;
      var progressBarFill = document.querySelector('.progress-bar-fill');
      var progressBarText = document.querySelector('.progress-bar-text');
      progressBarFill.style.width = percentComplete + '%';
      progressBarText.textContent = percentComplete + '%';
    }
  </script>
</body>

</html>