<?php 

require 'vendor/autoload.php';

use Espo\ApiClient\Client;
use Espo\ApiClient\Header;

// update this with your crm domain
$client = new Client('https://your-crm-domain.co.uk');
// create a api user and assign it a role with access (create document) and add api key here
$client->setApiKey('your-api-key-here');

// Initialize progress variables
$progressTotal = 0;
$progressCurrent = 0;
$error = '';

if (isset($_POST['submit'])) {

  $filesPath = $_POST['filePath'];
  

  // Validate the filePath field
  if (empty($filesPath)) {
      $error = "Please enter the full path to your files";
  } else {
      // Check if the filePath is a valid full path
      if (!is_dir($filesPath)) {
          $error = "Invalid directory path";
      }
  }

  $files = scandir($filesPath);
  $totalFiles = count($files) - 2;
  $count = 0;

  foreach ($files as $file) {

    if ($file !== '.' && $file !== '..') {
    
        $path = $filesPath . '/' . $file;
        $name = basename($path);
        $type = mime_content_type($path);
        $size = filesize($path);
        $fileContents = file_get_contents($path);
        $base64EncodedContent = 'data:' .$type . ';base64,' . base64_encode($fileContents);

        try {

            // Create attachment record
            $response = $client->request(
                Client::METHOD_POST,
                'Attachment',
                [
                  'name' => $name,
                  'type' => $type,
                  'role' => 'Attachment',
                  'relatedType' => 'Document',
                  'size' => $size,
                  'field' => 'file',
                  'file' => $base64EncodedContent,
                ],
                [new Header('Content-Type', 'application/json')]
            );

            // Check if the response was successful
            if ($response->getParsedBody()->id) {
                // Attachment created successfully
                $attachmentId = $response->getParsedBody()->id;

                try {
                  // Create document record
                  $response = $client->request(
                      Client::METHOD_POST,
                      'Document',
                      [
                        'name' => $name,
                        'fileId' => $attachmentId,
                        'publishDate' => date("Y-m-d"),
                      ],
                      [new Header('Content-Type', 'application/json')]
                  );
                } catch (Espo\ApiClient\Exception\ResponseError $e) {
                    // Handle the exception
                    echo 'Error Creating Document record: ' . $e->getCode();
                }

            } else {
                // Handle the error case for attachment creation
                echo 'Error creating attachment: ' . $response->getCode();
            }
        } catch (Espo\ApiClient\Exception\ResponseError $e) {
            // Handle the exception
            echo 'Error: ' . $e->getCode();
        }

        // Update progress variables
        $count++;
        $progressTotal = $totalFiles;
        $progressCurrent = $count;
        // flush();
    }
  }
}

function progressBar($progressTotal, $progressCurrent)
{
    $percentComplete = $progressTotal > 0 ? intval(($progressCurrent / $progressTotal) * 100) : 0;
    $barWidth = 300;
    $fillWidth = intval(($percentComplete / 100) * $barWidth);
    $barText = $percentComplete . '%';

    echo '<div class="progress-bar">';
    echo '<div class="progress-bar-fill" style="width: ' . $fillWidth . 'px;"></div>';
    echo '</div>';
    echo '<p class="progress-bar-text">' . $barText . '</p>';
}

?>

 <!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Attachment Uploader</title>
  <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.17/dist/tailwind.min.css" rel="stylesheet">
  <style>
    .progress-bar {
      width: 100%;
      background-color: #f2f2f2;
      border-radius: 4px;
      overflow: hidden;
      height: 10px;
    }
    .progress-bar-fill {
      background-color: #10b981;
      height: 100%;
      transition: width 0.3s ease-in-out;
    }
    .progress-bar-text {
      margin-top: 8px;
      font-size: 14px;
      font-weight: bold;
      text-align: center;
    }
  </style>
</head>

<body class="p-8">
  <div class="max-w-sm mx-auto">
    <h1 class="text-2xl font-bold mb-4">Espo API File Uploader</h1>
    <?php if (!empty($error)) : ?>
      <div class="bg-red-100 text-red-700 py-2 px-4 mb-4 rounded">
        <?php echo $error; ?>
      </div>
    <?php endif; ?>
    <form action="" method="POST" class="mb-6">
      <div class="mb-4">
        <label for="filePath" class="block mb-2">Full Files' Directory Path</label>
        <input type="text" id="filePath" name="filePath" placeholder="Enter the full path to your files"
          class="w-full px-4 py-2 border rounded focus:outline-none focus:border-blue-400">
      </div>
      <button type="submit" name="submit"
        class="w-full bg-blue-500 text-white font-bold py-2 px-4 rounded hover:bg-blue-600 transition duration-200">Start
        Uploading Files
      </button>
    </form>
    <?php
      progressBar($progressTotal, $progressCurrent);
    ?>
  </div>
  <script>
    function updateProgress(progressTotal, progressCurrent) {
      var percentComplete = progressTotal > 0 ? Math.floor((progressCurrent / progressTotal) * 100) : 0;
      var progressBarFill = document.querySelector('.progress-bar-fill');
      var progressBarText = document.querySelector('.progress-bar-text');
      progressBarFill.style.width = percentComplete + '%';
      progressBarText.textContent = percentComplete + '%';
    }
  </script>
</body>

</html>
