<?php

namespace Espo\Modules\modban\Controllers;

use Espo\Core\Exceptions\Error;
use Espo\Core\Exceptions\Forbidden;
use Espo\Core\Exceptions\BadRequest;

use Espo\Core\Api\Request;

use Espo\Core\Exceptions\NotFound;
use Espo\Modules\modban\Services\AutocompleteFromApi as Service;

class AutocompleteFromApi
{
    private Service $service;

    public function __construct(Service $service)
    {
        $this->service = $service;

    }

    public function actionFetchJson(Request $request): string
    {
        $q = $request->getQueryParam('q') ?? null;
        $scope = $request->getQueryParam('s') ?? null;
        $recordId = $request->getQueryParam('id') ?? null;
        $attribute = $request->getQueryParam('a') ?? null;
        // verify input completeness
        if (!$q) {
            throw new BadRequest("No 'q' parameter.");
        }
        if (!$scope) {
            throw new BadRequest("No 's' parameter.");
        }
        if (!$recordId) {
            throw new BadRequest("No 'id' parameter.");
        }
        if (!$attribute) {
            throw new BadRequest("No 'a' parameter.");
        }
        // remove all non-alphanumeric characters, allowing spaces to remain, and make the input string url safe
        $cleanQ = urlencode(preg_replace("/[^A-Za-z0-9 ]/", "", $q));        
        $payload = [];
        $payload['q'] = $cleanQ;
        $payload['scope'] = $scope;
        $payload['recordId'] = $recordId;
        $payload['attribute'] = $attribute;
        $payload['scope'] = $scope;
        // invoke the method fetchJsonFromApi at AutocompleteFromApi service class
        $autocompleteResponse = $this->service->fetchJsonFromApi($payload);
        return $autocompleteResponse;
    }    
}