define('modban:views/fields/varchar-autocomplete-from-api', 'views/fields/varchar', function (Dep) {

    return Dep.extend({

        autocompleteUrl: null,
        autocompleteGatewayUrl: "AutocompleteFromApi",
        autocompleteOptions: {},

        setup: function () {
            Dep.prototype.setup.call(this);    
            // direct the autocomplete Ajax call to the gateway url
            this.autocompleteUrl = this.autocompleteGatewayUrl+'/action/fetchJson?s='+this.entityType+'&id='+this.model.id+'&a='+this.name;
        },

        afterRender: function () {
            Dep.prototype.afterRender.call(this);
            // define autocomplete options for details on the autocomlete plug in options and methods visit: https://github.com/devbridge/jQuery-Autocomplete
            this.autocompleteOptions = {
                noCache: true,
                serviceUrl: this.autocompleteUrl,
                paramName: 'q',                    
                minChars: this.getMetadata().get(['entityDefs',this.entityType,'fields',this.name,'autocompleteMinChars']),                  
                beforeRender: ($c) => {
                    if (this.$element.hasClass('input-sm')) {
                        $c.addClass('small');
                    }
                },
                formatResult: (suggestion) => {
                    return this.getHelper().escapeString(suggestion.value);
                },        
                maxHeight: 200,                    
                onSearchStart: (q) => {
                        // called before the Ajax request is made - could be used to pre-filter the search string
                }                    
            };
            this.autocompleteOptions.transformResult = response => this.transformAutocompleteResult(response);

            if(this.isEditMode()) {
                this.$element.on('focus', () => {                            
                    // trigger autocomplete
                    this.$element.autocomplete(this.autocompleteOptions);
                    this.$element.attr('autocomplete', 'espo-' + this.name);

                });  
                // define actions to take, if any, when the field value is being updated
                this.$element.on("input", () => {
                    // define actions here
                });
                // remove the autocomplete functionality after a field is saved and rendered again in detail mode
                this.once('render', () => {
                    this.$element.autocomplete('dispose');
                });
                // remove the autocomplete functoinality if a field element is removed
                this.once('remove', () => {
                    this.$element.autocomplete('dispose');
                });

            }
        },

        // This function will need to be customized according to the structure of the JSON response from the external server
        transformAutocompleteResult: function (response) {
            let parsedResponse = JSON.parse(response);
            let list = [];

            // API RESPONSE SPECIFIC VALUES
            const jsonResponseDataContainer = 'features';
            const jsonResponseItemAttribute = 'properties';  

            parsedResponse[jsonResponseDataContainer].forEach(item => {
                list.push({
                    id: item[jsonResponseItemAttribute].id,
                    name: item[jsonResponseItemAttribute].name || item[jsonResponseItemAttribute].id,
                    data: item[jsonResponseItemAttribute].id,
                    value: item[jsonResponseItemAttribute].name || item[jsonResponseItemAttribute].id,
                    attributes: item[jsonResponseItemAttribute]
                });
            });

            return {
                suggestions: list
            };
        }
   });

});