<?php

namespace Espo\Modules\modban\Services;

use Espo\Core\Exceptions\Error;

class AutocompleteFromApi extends \Espo\Core\Templates\Services\Base
{
    public function fetchJsonFromApi ($payload) {
        // get the exernal api url from the scope's entityDefs
        $autocompleteUrl = $this->metadata->get(['entityDefs', $payload['scope'], 'fields', $payload['attribute'], 'autocompleteSourceUrl']).'?q='.$payload['q'];
        // get the API query paramteres from metadata
        $qUrlModifier = $this->metadata->get(['entityDefs', $payload['scope'], 'fields', $payload['attribute'], 'autocompleteQmodifier']);
        if(empty($qUrlModifier)) {
            $qUrlModifier = '';
        }
        $urlFilters = $this->metadata->get(['entityDefs', $payload['scope'], 'fields', $payload['attribute'], 'autocompleteQueryFilters']);
        $urlFilterModifier = '';
        if(!empty($urlFilters)) {
            $entity = $this->entityManager->getEntityById($payload['scope'], $payload['recordId']);
            foreach($urlFilters as $filter) {
                foreach($filter as $key => $val) {
                    if(str_contains($val, '.val()')) {
                        $filterParts = explode('.',$val);      
                        $value = $entity->get($filterParts[0]);
                        if(!empty($value)) {
                            $urlFilterModifier.='&'.$key.'='.$value;
                        }
                    } else {
                        $urlFilterModifier.='&'.$key.'='.$val;
                    }                    
                }
            }

        }
        $url = $autocompleteUrl.$qUrlModifier.$urlFilterModifier;
        $json = $this->callAPI('GET',$url);
        return $json;
    }

    private function callAPI($method, $url, $data=false){
        $curl = curl_init();
        switch ($method){
            case "POST":
                curl_setopt($curl, CURLOPT_POST, 1);
                if ($data)
                    curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
                break;
            case "PUT":
                curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PUT");
                if ($data)
                    curl_setopt($curl, CURLOPT_POSTFIELDS, $data);                                
                break;
            default:
                if ($data)
                    $url = sprintf("%s?%s", $url, http_build_query($data));
        }
        // set curl options:
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'APIKEY: 111111111111111111111',
            'Content-Type: application/json',
        ));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        // execute curl:
        $result = curl_exec($curl);
        if(!$result){die("Connection Failure");}
        curl_close($curl);
        return $result;
    }    

    private function buildUrl($action, $params = [])
    {
        $params['private_token'] = self::PRIVATE_TOKEN;

        $url = self::API_URL . $action . '?';

        $count = count($params);
        $i = 0;

        foreach ($params as $key => $value) {
            if (!empty($value)) {
                $url .= $key . '=' . $value;            
            }
            $i++;
            if ($i < ($count)) {
                $url .= '&';                
            }
        }

        return $url;        
    }  

}