<?php

namespace Espo\Modules\CustomPortalUsers\Classes\Select\Angestellte\AccessControlFilters;

use Espo\Core\Select\AccessControl\Filter;
use Espo\ORM\Query\SelectBuilder;
use Espo\Entities\User;

class PortalOnlyContact implements Filter
{
    private $user;

    public function __construct(User $user)
    {
        $this->user = $user;
    }

    public function apply(SelectBuilder $queryBuilder): void
    {
        $angestellteId = $this->user->get('angestellteId');

        if ($angestellteId === null) {
            $queryBuilder->where([
                'id' => null
            ]);

            return;
        }

        $queryBuilder->where([
            'id' => $angestellteId
        ]);
    }
}