define('ModBAN:views/contact/fields/voieban', ['views/fields/base'], function (Dep) {

    /**
     * A text field.
     *
     * @class
     * @name Class
     * @extends module:views/fields/base.Class
     * @memberOf module:views/fields/text
     */
    return Dep.extend(/** @lends module:views/fields/text.Class# */{

        type: 'voieban',

        listTemplate: 'ModBAN:contact/fields/voieban/list',

        detailTemplate: 'ModBAN:contact/fields/voieban/detail',

        editTemplate: 'ModBAN:contact/fields/voieban/edit',

        searchTemplate: 'ModBAN:contact/fields/voieban/search',

        seeMoreText: false,

        rowsDefault: 10,

        rowsMin: 2,

        seeMoreDisabled: false,

        cutHeight: 200,

        searchTypeList: [
            'contains',
            'startsWith',
            'equals',
            'endsWith',
            'like',
            'notContains',
            'notLike',
            'isEmpty',
            'isNotEmpty',
        ],

        noResize: false,

        changeInterval: 5,

        events: {
            'click a[data-action="seeMoreText"]': function (e) {
                this.seeMoreText = true;
                this.reRender();
            },
            'click [data-action="mailTo"]': function (e) {
                this.mailTo($(e.currentTarget).data('email-address'));
            },
        },

        setup: function () {
            Dep.prototype.setup.call(this);

            this.params.rows = this.params.rows || this.rowsDefault;
            this.noResize = this.options.noResize || this.params.noResize || this.noResize;
            this.seeMoreDisabled = this.seeMoreDisabled || this.params.seeMoreDisabled;
            this.autoHeightDisabled = this.options.autoHeightDisabled || this.params.autoHeightDisabled ||
                this.autoHeightDisabled;

            if (this.params.cutHeight) {
                this.cutHeight = this.params.cutHeight;
            }

            this.rowsMin = this.options.rowsMin || this.params.rowsMin || this.rowsMin;

            if (this.params.rows < this.rowsMin) {
                this.rowsMin = this.params.rows;
            }

            this.on('remove', () => {
                $(window).off('resize.see-more-' + this.cid);
            });
        },

        setupSearch: function () {
            this.events = _.extend({
                'change select.search-type': function (e) {
                    var type = $(e.currentTarget).val();
                    this.handleSearchType(type);
                },
            }, this.events || {});
        },

        data: function () {
            var data = Dep.prototype.data.call(this);

            if (
                this.model.get(this.name) !== null &&
                this.model.get(this.name) !== '' &&
                this.model.has(this.name)
            ) {
                data.isNotEmpty = true;
            }

            if (this.mode === this.MODE_SEARCH) {
                if (typeof this.searchParams.value === 'string') {
                    this.searchData.value = this.searchParams.value;
                }
            }

            if (this.mode === this.MODE_EDIT) {
                if (this.autoHeightDisabled) {
                    data.rows = this.params.rows;
                } else {
                    data.rows = this.rowsMin;
                }
            }

            data.valueIsSet = this.model.has(this.name);

            if (this.isReadMode()) {
                data.isCut = this.isCut();

                if (data.isCut) {
                    data.cutHeight = this.cutHeight;
                }

                data.displayRawText = this.params.displayRawText;
            }

            data.noResize = this.noResize;

            return data;
        },

        handleSearchType: function (type) {
            if (~['isEmpty', 'isNotEmpty'].indexOf(type)) {
                this.$el.find('input.main-element').addClass('hidden');
            } else {
                this.$el.find('input.main-element').removeClass('hidden');
            }
        },

        getValueForDisplay: function () {
            var text = this.model.get(this.name);

            return text || '';
        },

        controlTextareaHeight: function (lastHeight) {
            var scrollHeight = this.$element.prop('scrollHeight');
            var clientHeight = this.$element.prop('clientHeight');

            if (typeof lastHeight === 'undefined' && clientHeight === 0) {
                setTimeout(this.controlTextareaHeight.bind(this), 10);

                return;
            }

            if (clientHeight === lastHeight) {
                return;
            }

            if (scrollHeight > clientHeight + 1) {
                var rows = this.$element.prop('rows');

                if (this.params.rows && rows >= this.params.rows) {
                    return;
                }

                this.$element.attr('rows', rows + 1);
                this.controlTextareaHeight(clientHeight);
            }

            if (this.$element.val().length === 0) {
                this.$element.attr('rows', this.rowsMin);
            }
        },

        isCut: function () {
            return !this.seeMoreText && !this.seeMoreDisabled;
        },

        controlSeeMore: function () {
            if (!this.isCut()) {
                return;
            }

            if (this.$text.height() > this.cutHeight) {
                this.$seeMoreContainer.removeClass('hidden');
                this.$textContainer.addClass('cut');
            } else {
                this.$seeMoreContainer.addClass('hidden');
                this.$textContainer.removeClass('cut');
            }
        },

        afterRender: function () {
            Dep.prototype.afterRender.call(this);

            if (this.isReadMode()) {
                $(window).off('resize.see-more-' + this.cid);

                this.$textContainer = this.$el.find('> .complex-text-container');
                this.$text = this.$textContainer.find('> .complex-text');
                this.$seeMoreContainer = this.$el.find('> .see-more-container');

                if (this.isCut()) {
                    this.controlSeeMore();

                    if (this.model.get(this.name) && this.$text.height() === 0) {
                        this.$textContainer.addClass('cut');

                        setTimeout(this.controlSeeMore.bind(this), 50);
                    }

                    this.listenTo(this.recordHelper, 'panel-show', () => this.controlSeeMore());
                    this.on('panel-show-propagated', () => this.controlSeeMore());

                    $(window).on('resize.see-more-' + this.cid, () => {
                        this.controlSeeMore();
                    });
                }
            }

            if (this.mode === this.MODE_EDIT) {
                this.$rueBAN.on('change', () => {
                    this.trigger('change');
                });

                this.$rueBAN.autocomplete({
                    source: function (request, response) {
                        $.ajax({
                            url: "https://api-adresse.data.gouv.fr/search/?postcode=01000",
                            data: { q: request.term },
                            dataType: "json",
                            success: function (data) {
                                response($.map(data.features, function (item) {
                                    return { label: item.properties.name, value: item.properties.name};
                                }));
                            }
                        });
                    }
                });
                this.$rueBAN.on('focus', function () {
                    if (this.$rueBAN.val()) return;
                    this.$rueBAN.autocomplete('onValueChange');
                }.bind(this));
                this.once('render', function () {
                    this.$rueBAN.autocomplete('dispose');
                }, this);
                this.once('remove', function () {
                    this.$rueBAN.autocomplete('dispose');
                }, this);
            }

            if (this.mode === this.MODE_SEARCH) {
                var type = this.$el.find('select.search-type').val();

                this.handleSearchType(type);

                this.$el.find('select.search-type').on('change', () => {
                    this.trigger('change');
                });

                this.$element.on('input', () => {
                    this.trigger('change');
                });
            }

            if (this.mode === this.MODE_EDIT && !this.autoHeightDisabled) {
                this.controlTextareaHeight();

                this.$element.on('input', () => {
                    this.controlTextareaHeight();
                });

                let lastChangeKeydown = new Date();
                const changeKeydownInterval = this.changeInterval * 1000;

                this.$element.on('keydown', () => {
                    if (Date.now() - lastChangeKeydown > changeKeydownInterval) {
                        this.trigger('change');
                        lastChangeKeydown = Date.now();
                    }
                });
            }
        },

        fetch: function () {
            let data = {};

            let value = this.$element.val() || null;

            if (value && value.trim() === '') {
                value = '';
            }

            data[this.name] = value

            return data;
        },

        fetchSearch: function () {
            var type = this.fetchSearchType() || 'startsWith';

            var data;

            if (~['isEmpty', 'isNotEmpty'].indexOf(type)) {
                if (type === 'isEmpty') {
                    data = {
                        type: 'or',
                        value: [
                            {
                                type: 'isNull',
                                field: this.name,
                            },
                            {
                                type: 'equals',
                                field: this.name,
                                value: ''
                            }
                        ],
                        data: {
                            type: type
                        }
                    };
                } else {
                    data = {
                        type: 'and',
                        value: [
                            {
                                type: 'notEquals',
                                field: this.name,
                                value: ''
                            },
                            {
                                type: 'isNotNull',
                                field: this.name,
                                value: null
                            }
                        ],
                        data: {
                            type: type
                        }
                    };
                }

                return data;
            }
            else {
                var value = this.$element.val().toString().trim();

                value = value.trim();

                if (value) {
                    data = {
                        value: value,
                        type: type
                    };

                    return data;
                }
            }

            return false;
        },

        getSearchType: function () {
            return this.getSearchParamsData().type || this.searchParams.typeFront ||
                this.searchParams.type;
        },

        mailTo: function (emailAddress) {
            var attributes = {
                status: 'Draft',
                to: emailAddress
            };

            if (
                this.getConfig().get('emailForceUseExternalClient') ||
                this.getPreferences().get('emailUseExternalClient') ||
                !this.getAcl().checkScope('Email', 'create')
            ) {
                require('email-helper', (EmailHelper) => {
                    var emailHelper = new EmailHelper();

                    var link = emailHelper
                        .composeMailToLink(attributes, this.getConfig().get('outboundEmailBccAddress'));

                    document.location.href = link;
                });

                return;
            }

            var viewName = this.getMetadata().get('clientDefs.' + this.scope + '.modalViews.compose') ||
                'views/modals/compose-email';

            Espo.Ui.notify(' ... ');

            this.createView('quickCreate', viewName, {
                attributes: attributes,
            }, (view) => {
                view.render();
                view.notify(false);
            });
        },
    });
});
