<?php
namespace Espo\Modules\MedyaMods\Controllers;

use Espo\Core\Exceptions\BadRequest;
use Espo\Core\Exceptions\Error;
use Espo\Core\Api\Response;
use Espo\Core\Api\Request;

class GetRandomTeamMember extends \Espo\Core\Templates\Controllers\Base
{
    public function getActionRandomize(Request $request, Response $response)
    {
        $params = $request->getQueryParams();

        $errors = array();

        if (!array_key_exists("teamName", $params) or !isset($params["teamName"]))
        {
            $errors[] = "Missing or invalid parameter: teamName";
        }

        if (count($errors))
        {
            $output = array(
                "status" => "Error",
                "errors" => $errors,
            );
        }
        else
        {
            $team = $this
                ->entityManager
                ->getRDBRepository('Team')
                ->select(['id', 'useWeightInOpportunitiesDistribution', ])
                ->where(['name' => $params['teamName'], ])->findOne();

            $team = $team->toArray();

            $select = !$team['useWeightInOpportunitiesDistribution'] ? ['id'] : ['id', 'weightInOpportunitiesDistribution', ];

            $users = $this
                ->entityManager
                ->getRDBRepository("User")
                ->join("teams")
                ->select($select)->where(["teams.name" => $params["teamName"], "isActive" => True, ])->find();

            $users = $users->toArray();

            $userId = '';

            if (!$team)
            {
                $errors[] = "There isn't a team with this teamName.";
            }

            if (!$users)
            {
                $errors[] = "There isn't users in team with this teamName.";
            }

            if (count($errors))
            {
                $output = array(
                    "status" => "Error",
                    "errors" => $errors,
                );
            }
            else
            {
                if (!$team['useWeightInOpportunitiesDistribution'])
                {
                    shuffle($users);

                    $userId = $users[0]['id'];
                }
                else
                {
                    $sum = 0;
                    $rangedUsers = [];

                    foreach ($users as $user)
                    {
                        $sum += $user['weightInOpportunitiesDistribution'];
                    }

                    $accumulated = 0;
                    foreach ($users as $user)
                    {
                        $accumulated += $user['weightInOpportunitiesDistribution'] * (100 / $sum);

                        $rangedUsers[$user['id']] = round($accumulated, 2);
                    }

                    $rand = round(mt_rand(0, 10000) / 100, 2);

                    foreach ($rangedUsers as $id => $max)
                    {
                        if ($rand <= $max)
                        {
                            $userId = $id;

                            break;
                        }
                    }
                }

                $output = array(
                    "status" => "Success",
                    "data" => ['userId' => $userId,
                    'teamId' => $team['id'],
                    ],
                );
            }
        }

        $response->writeBody(json_encode($output));
    }
}

