<?php
use Espo\ORM\Entity;
use Espo\Entities\Attachment;
class AfterInstall
{

  public function run($container, $params = [])
    {
        $this->container = $container;
        $entityManager = $container->get('entityManager');
        $contents = file_get_contents('client/modules/logo-upload/img/logo.png');
        $attachment = $entityManager->getNewEntity('Attachment');
        $attachment->set([
            'name' => 'logo.png',
            'type' => 'image/png',
            'role' => 'Attachment',
            'contents' => $contents,
            'relatedType'=> 'Settings',
            'field' => 'companyLogo'
        ]);
        $entityManager->saveEntity($attachment);
        $config = $this->container->get('config');

        $config->set('companyLogoId', $attachment->get('id'));
        $config->set('companyLogoName', $attachment->get('name'));
        $config->save();


        $this->clearCache();
    }
    protected function clearCache()
    {
        try {
            $this->container->get('dataManager')->clearCache();
        } catch (\Exception $e) {
        }
    }
  }
