define('custom:record-tabbed', [], function () {

    var Handler = function (view) {
        this.view = view;
    };

    _.extend(Handler.prototype, {
        
        process: function () {   
            this.view.createMiddleView = function (callback) {                                     
                var el = this.options.el || '#' + (this.id);
    
                this.waitForView('middle');
    
                this.getGridLayout(function (layout) {
                    layout.type = "custom:record-tabbed";
                    this.createView('middle', this.middleView, {                        
                        model: this.model,
                        scope: this.scope,
                        type: this.type,
                        _layout: layout,
                        el: el + ' .middle',
                        layoutData: {
                            model: this.model,
                        },
                        recordHelper: this.recordHelper,
                        recordViewObject: this,
                        panelFieldListMap: this.panelFieldListMap,
                    }, callback);
                }.bind(this));
            };

            this.view.bottomView = 'custom:views/record/detail-bottom';                                                
        }        
    });

    _.extend(Handler.prototype, Backbone.Events);

    return Handler;
});