define('formula-refresh:unrestricted-recalculate-formula-handler', ['action-handler'], function (Dep) {

    return Dep.extend({

        actionRecalculate: function (data, e) {

            var data = this.getActionSelectionPostData();
            data['scope'] = this.view.scope;
            // make an Ajax call to a custom back-end controller class
            Espo.Ajax.postRequest('RecalculateFormula', data).then(function (result) {
                // refresh the view after the back-end operation has been successfuly completed
                this.view.model.fetch();
                this.view.notify('Saved', 'success');
                this.view.reRender();
            }.bind(this));
        },

        initRecalculate: function () {
        },

        controlButtonVisibility: function () {
        },

        getActionSelectionPostData: function () {
            var data = {};
            var ids = false;
            if (this.view.model.id) {
                data.ids = [];
                data.ids.push(this.view.model.id);
            }
            return data;
        }
    });
});