define('custom:views/record/search', 'views/record/search', function (Dep) {

    return Dep.extend({

        template: 'custom:record/search',

        setup: function () {
            Dep.prototype.setup.call(this);
        },

        events: {
            'keypress input[data-name="textFilter"]': function (e) {
                if (e.keyCode == 13) {
                    this.search();
                }
            },
            'focus input[data-name="textFilter"]': function (e) {
                e.currentTarget.select();
            },
            'click button[data-action="search"]': function (e) {
                this.search();
            },
            'click a[data-action="addFilter"]': function (e) {
                var $target = $(e.currentTarget);
                var name = $target.data('name');
                this.advanced[name] = {};

                $target.closest('li').addClass('hidden');

                this.presetName = this.primary;

                this.createFilter(name, {}, function (view) {
                    view.populateDefaults();
                    this.fetch();
                    this.updateSearch();
                }.bind(this));
                this.updateAddFilterButton();
                this.handleLeftDropdownVisibility();

                this.manageLabels();
                this.controlResetButtonVisibility();
                this.controlRefreshButtonVisibility();
            },
            'click .advanced-filters a.remove-filter': function (e) {
                var $target = $(e.currentTarget);
                var name = $target.data('name');

                this.$el.find('ul.filter-list li[data-name="' + name + '"]').removeClass('hidden');
                var container = this.getView('filter-' + name).$el.closest('div.filter');
                this.clearView('filter-' + name);
                container.remove();
                delete this.advanced[name];


                this.presetName = this.primary;

                this.updateAddFilterButton();

                this.fetch();
                this.updateSearch();

                this.manageLabels();
                this.handleLeftDropdownVisibility();
                this.controlResetButtonVisibility();
                this.controlRefreshButtonVisibility();
            },
            'click button[data-action="reset"]': function (e) {
                this.resetFilters();
            },
            'click button[data-action="refreshFilter"]': function (e) {
                this.refreshFilters();
            },
            'click a[data-action="selectPreset"]': function (e) {
                var presetName = $(e.currentTarget).data('name') || null;
                this.selectPreset(presetName);
            },
            'click .advanced-filters-bar a[data-action="showFiltersPanel"]': function (e) {
                this.$advancedFiltersPanel.removeClass('hidden');
            },
            'click .dropdown-menu a[data-action="savePreset"]': function (e) {
                this.createView('savePreset', 'views/modals/save-filters', {}, function (view) {
                    view.render();
                    this.listenToOnce(view, 'save', function (name) {
                        this.savePreset(name);
                        view.close();

                        this.removeFilters();
                        this.createFilters(function () {
                            this.render();
                        }.bind(this));

                    }, this);
                }.bind(this));
            },
            'click .dropdown-menu a[data-action="removePreset"]': function (e) {
                var id = this.presetName;
                this.confirm(this.translate('confirmation', 'messages'), function () {
                    this.removePreset(id);
                }, this);
            },
            'change .search-row ul.filter-menu input[data-role="boolFilterCheckbox"]': function (e) {
                e.stopPropagation();
                this.search();
                this.manageLabels();
            },
            'click [data-action="switchViewMode"]': function (e) {
                var mode = $(e.currentTarget).data('name');

                if (mode === this.viewMode) return;

                this.setViewMode(mode, false, true);
            }
        },

        refreshFilters: function () {
            this.textFilter = '';
            for (var valueIndex in this.advanced) {
                this.advanced[valueIndex] = false;
            }
            this.trigger('reset');

            this.collection.resetOrderToDefault();
            this.selectPreset(this.presetName, false);
        },

        controlRefreshButtonVisibility: function () {
            var presetName = this.presetName || null;
            var primary = this.primary;

            var $refreshButton = this.$refreshButton;

            var toShow = false;

            if (this.textFilter) {
                toShow = true;
            } else {
                if (presetName && presetName != primary) {

                } else {
                    if (Object.keys(this.advanced).length) {
                        toShow = true;
                    }
                }
            }

            if (!toShow) {
                if (
                    this.collection.orderBy !== this.collection.defaultOrderBy ||
                    this.collection.order !== this.collection.defaultOrder
                ) {
                    toShow = true;
                }
            }

            if (toShow) {
                $refreshButton.css('visibility', 'visible');
            } else {
                $refreshButton.css('visibility', 'hidden');
            }
        },

        afterRender: function () {
            Dep.prototype.afterRender.call(this);

            this.$refreshButton = this.$el.find('[data-action="refreshFilter"]');
            this.controlRefreshButtonVisibility();
        },

        search: function () {
            this.fetch();
            this.updateSearch();
            this.updateCollection();
            this.controlResetButtonVisibility();
            this.controlRefreshButtonVisibility();
        }
    });
});
