<?php
/**
 * This code will run when the pod is brought up.
 * It will spin up a server and start listening to port 8080 and on also
 * listen for updates in the app and bgt container.
 */
if (substr(php_sapi_name(), 0, 3) != 'cli') {
    die('WebSocket can be run only via CLI.');
}

include '/www/espocrm/bootstrap.php';

$app = new \Espo\Core\Application();

// load the config file
$config = $app->getContainer()->get('config');
// get the container ip
// if not present kill the script
$containerIp = gethostbyname(gethostname());
if (empty($containerIp)) {
    die('Container ip not found.');
}

// set the webSocketSubmissionDsn to the container ip and save
// Since the config file is shared between app, bgt and socket.
// Any updates to the config file will be available to all the containers
$socketSubmissionDsn = "tcp://{$containerIp}:5555";
$config->set('webSocketSubmissionDsn', $socketSubmissionDsn);
$config->save();

$categoriesData = $app->getContainer()->get('metadata')->get(['app', 'webSocket', 'categories'], []);

$phpExecutablePath = $config->get('phpExecutablePath');
$isDebugMode = (bool) $config->get('webSocketDebugMode');

$loop = \React\EventLoop\Factory::create();
$pusher = new \Espo\Core\WebSocket\Pusher($categoriesData, $phpExecutablePath, $isDebugMode);

// make the socket container listen on port 5555
// if the app or bgt container want to communicate something over the socket connection
// they need to send the message through the url, webSocketSubmissionDsn, specfied in config file
// eg: When a client makes a post request to the server, after the server has done executing
// it should inform all the other clients connected to this socket about the changes done.
$context = new \React\ZMQ\Context($loop);
$pull = $context->getSocket(\ZMQ::SOCKET_PULL);
$pull->bind('tcp://*:5555');
$pull->on('message', [$pusher, 'onMessageReceive']);

$useSecureServer = $config->get('webSocketUseSecureServer');
$port = $config->get('webSocketPort');
if (!$port) {
    $port = $useSecureServer ? '8443' : '8080';
}

// Set up websocket connection
$webSocket = new \React\Socket\Server('0.0.0.0:'.$port, $loop);

if ($useSecureServer) {
    $sslParams = [
        'local_cert' => $config->get('webSocketSslCertificateFile'),
        'allow_self_signed' => $config->get('webSocketSslAllowSelfSigned', false),
        'verify_peer' => false,
    ];
    if ($config->get('webSocketSslCertificatePassphrase')) {
        $sslParams['passphrase'] = $config->get('webSocketSslCertificatePassphrase');
    }
    if ($config->get('webSocketSslCertificateLocalPrivateKey')) {
        $sslParams['local_pk'] = $config->get('webSocketSslCertificateLocalPrivateKey');
    }
    $webSocket = new \React\Socket\SecureServer($webSocket, $loop, $sslParams);
}

$webServer = new \Ratchet\Server\IoServer(
    new \Ratchet\Http\HttpServer(
        new \Ratchet\WebSocket\WsServer(
            new \Ratchet\Wamp\WampServer($pusher)
        )
    ),
    $webSocket
);

// $timer = $loop->addPeriodicTimer(25, function () {
//     try {
//         $context = new \ZMQContext();
//         $socket = $context->getSocket(\ZMQ::SOCKET_PUSH, 'my pusher');

//         $dsn = 'tcp://localhost:5555';

//         $socket->connect($dsn);

//         $data = json_encode(['topicId' => 'newNotification']);
//         $socket->send(json_encode($data));

//         $socket->setSockOpt(\ZMQ::SOCKOPT_LINGER, 1000);
//         $socket->disconnect($dsn);
//     } catch (\Throwable $e) {
//         $GLOBALS['log']->error('WebSocketSubmission: '.$e->getMessage());
//     }
// });

$loop->run();
