<?php

if (substr(php_sapi_name(), 0, 3) != 'cli') exit;

include "bootstrap.php";

$app = new \Espo\Core\Application();
$app->setupSystemUser();

$mb4Converter = new Mb4Converter($app->getContainer());
$mb4Converter->run();

class Mb4Converter
{
    private $container;

    public function __construct($container)
    {
        $this->container = $container;
    }

    protected function getContainer()
    {
        return $this->container;
    }

    public function run()
    {
        fwrite(\STDOUT, "We strongly recommend to create a backup of your database, https://docs.espocrm.com/administration/backup-and-restore/#step-2-backup-database.\n");
        sleep(1);

        fwrite(\STDOUT, "All fields will be converted to utf8mb4_unicode_ci collation. Enter [Y] to continue.\n");

        if (!$this->confirm()) {
            echo "Canceled.\n";
            return;
        }

        $this->convert();
    }

    protected function confirm()
    {
        $fh = fopen('php://stdin', 'r');
        $inputLine = trim(fgets($fh));
        fclose($fh);
        if (strtolower($inputLine) !== 'y'){
            return false;
        }
        return true;
    }

    protected function convert()
    {
        $container = $this->getContainer();

        $pdo = $container->get('entityManager')->getPDO();

        try {
            $sth = $pdo->prepare('show tables');
            $sth->execute();
        } catch (\Exception $e) {
            fwrite(\STDOUT, "Error: cannot get table list.\n");
            exit;
        }

        $tableList = $sth->fetchAll(\PDO::FETCH_NUM);

        if (empty($tableList)) {
            fwrite(\STDOUT, "Error: empty table list.\n");
            exit;
        }

        $listTypes = [];

        foreach ($tableList as $item) {

            $tableName = $item[0];

            //Get table columns params
            $query = "SHOW FULL COLUMNS FROM `". $tableName ."` WHERE `Collation` <> 'utf8mb4_unicode_ci'";

            try {
                $sth = $pdo->prepare($query);
                $sth->execute();
            } catch (\Exception $e) {
                $GLOBALS['log']->debug('Utf8mb4: Table does not exist - ' . $e->getMessage());
                continue;
            }

            $rowList = $sth->fetchAll(\PDO::FETCH_ASSOC);

            $columns = array();
            foreach ($rowList as $row) {
                $columns[ $row['Field'] ] = $row;
            }
            //END: get table columns params

            if (empty($columns)) {
                continue;
            }

            fwrite(\STDOUT, "Table: " . $tableName);

            foreach ($columns as $columnName => $columnParams) {

                fwrite(\STDOUT, ".");

                $query = null;

                $columnType = $this->getColumnType($columnParams['Type']);

                switch ($columnType) {
                    case 'varchar':
                    case 'text':
                    case 'mediumtext':
                    case 'longtext':
                        $query = "ALTER TABLE `". $tableName ."`
                            CHANGE COLUMN `". $columnName ."` `". $columnName ."` ". $columnParams['Type'] ."
                            CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
                        ";
                        break;
                }

                if (!empty($query)) {
                    $GLOBALS['log']->debug('Utf8mb4: execute the query - [' . $query . '].');

                    try {
                        $sth = $pdo->prepare($query);
                        $sth->execute();
                    } catch (\Exception $e) {
                        $GLOBALS['log']->warning('Utf8mb4: FAILED executing the query - [' . $query . '], details: '. $e->getMessage() .'.');
                    }
                }
            }

            fwrite(\STDOUT, "\n");
        }

        $config = $container->get('config');
        $database = $config->get('database');
        if (!isset($database['charset']) || $database['charset'] != 'utf8mb4') {
            $database['charset'] = 'utf8mb4';
            $config->set('database', $database);
            $config->save();
        }

        $this->getContainer()->get('dataManager')->rebuild();

        fwrite(\STDOUT, "Successfully completed.\n");
    }

    protected function getColumnType($type)
    {
        if (preg_match('/^(.*)\(/i', $type, $match)) {
            return strtolower($match[1]);
        }

        return strtolower($type);
    }
}