<?php
/************************************************************************
 * This file is part of EspoCRM.
 *
 * EspoCRM - Open Source CRM application.
 * Copyright (C) 2014-2018 Yuri Kuznetsov, Taras Machyshyn, Oleksiy Avramenko
 * Website: http://www.espocrm.com
 *
 * EspoCRM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EspoCRM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with EspoCRM. If not, see http://www.gnu.org/licenses/.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "EspoCRM" word.
 ************************************************************************/

namespace Espo\Custom\Core\Formula\Functions\StringGroup;

use \Espo\Core\Exceptions\Error;

class Latitude extends \Espo\Core\Formula\Functions\Base
{
    public function process(\StdClass $item)
    {
        if (!property_exists($item, 'value')) {
            throw new Error();
        }

        if (!$item->value[0]) {
            throw new Error();
        }

        $opts = [
          'http' => [
            'method'=>"GET",
            'header'=>"User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:59.0) \r\n"
          ]
        ];
        $street = str_replace (' ', '+',$this->evaluate($item->value[0]));
        $postalCode = str_replace (' ', '+',$this->evaluate($item->value[1]));
        $city = str_replace (' ', '+',$this->evaluate($item->value[2]));
        $state = str_replace (' ', '+',$this->evaluate($item->value[3]));
        $address = $street .'+' .$postalCode .'+' .$city .'+' .$state;
        $url = "https://geocoder.api.here.com/6.2/geocode.json?".urlencode("app_id=pAPP_IDv&app_code=APP_CODE={$address}");
        $context = stream_context_create($opts);
        $jsonfile = file_get_contents($url, false, $context);
        $result = json_decode($jsonfile, true);
        return $result['Response']['View'][0]['Result'][0]['Location']['DisplayPosition']['Latitude'] ;
    }
}
