/************************************************************************
 * This file is part of EspoCRM.
 *
 * EspoCRM - Open Source CRM application.
 * Copyright (C) 2014-2019 Yuri Kuznetsov, Taras Machyshyn, Oleksiy Avramenko
 * Website: https://www.espocrm.com
 *
 * EspoCRM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EspoCRM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with EspoCRM. If not, see http://www.gnu.org/licenses/.
 ************************************************************************/

Espo.define('views/fields/map', 'views/fields/base', function (Dep) {

    return Dep.extend({

        type: 'map',

        detailTemplate: 'fields/map/detail',

        addressField: null,

        provider: null,

        height: 300,

        data: function () {
            var data = Dep.prototype.data.call(this);
            return data;
        },

        setup: function () {
             var linkElement = document.createElement('link');
                linkElement.type = 'text/css';
                linkElement.rel = 'stylesheet';
                linkElement.href = 'https://openlayers.org/en/v4.6.5/css/ol.css';
                document.head.appendChild(linkElement);
                var src = 'https://openlayers.org/en/v4.6.5/build/ol.js';

                var s = document.createElement('script');
                s.setAttribute('async', 'async');
                s.src = src;
                document.head.appendChild(s);

            this.provider = this.params.provider;
            this.height = this.params.height || this.height;


            this.listenTo(this.model, 'after:save', function () {
                if (this.isRendered()) {
                    this.reRender();
                }
            }, this);

            this.listenTo(this.model, 'change', function (model) {
                this.reRender();
            }, this);
        },

        afterRender: function () {

            if (this.model.get('lat')){
               var methodName = 'afterRenderOpenStreet';
                if (typeof this[methodName] === 'function') {
                    this[methodName]();
                }
                this.initMapOpenStreet();
            }
        },

        afterRenderOpenStreet: function () {
            //this.initMapOpenStreet();
        },

        initMapOpenStreet: function () {
            this.$el.find('.map').css('height', this.height + 'px');
            var map;
            var mapLat = this.model.get('lat');
            var mapLng =  this.model.get('lon');
            var mapDefaultZoom = 14;

            try {
                map = new ol.Map({
                    target: "map",
                    layers: [
                        new ol.layer.Tile({
                            source: new ol.source.OSM({
                                  url: "https://a.tile.openstreetmap.org/{z}/{x}/{y}.png"
                            })
                        })
                    ],
                    view: new ol.View({
                        center: ol.proj.fromLonLat([mapLng, mapLat]),
                        zoom: mapDefaultZoom
                    })
                  });
            } catch (e) {
                console.error(e.message);
                return;
            }

            var lat = this.model.get('lat');
            var lng = this.model.get('lon');

              var vectorLayer = new ol.layer.Vector({
                source:new ol.source.Vector({
                  features: [new ol.Feature({
                        geometry: new ol.geom.Point(ol.proj.transform([parseFloat(lng), parseFloat(lat)], 'EPSG:4326', 'EPSG:3857')),
                    })]
                }),
                style: new ol.style.Style({
                  image: new ol.style.Icon({
                    anchor: [0.5, 0.5],
                    anchorXUnits: "fraction",
                    anchorYUnits: "fraction",
                    src: "data/RedDot.svg"
                  })
                })
              });

              map.addLayer(vectorLayer);

        }

    });

});
