<?php
/************************************************************************
 * This file is part of EspoCRM.
 *
 * EspoCRM - Open Source CRM application.
 * Copyright (C) 2014-2018 Yuri Kuznetsov, Taras Machyshyn, Oleksiy Avramenko
 * Website: http://www.espocrm.com
 *
 * EspoCRM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EspoCRM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with EspoCRM. If not, see http://www.gnu.org/licenses/.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "EspoCRM" word.
 ************************************************************************/

namespace Espo\Core\Formula\Functions\StringGroup;

use \Espo\Core\Exceptions\Error;

class GetafterwordType extends \Espo\Core\Formula\Functions\Base
{
    public function process(\StdClass $item)
    {
        if (!property_exists($item, 'value')) {
            return '';
        }

        if (!is_array($item->value)) {
            throw new Error();
        }

        if (count($item->value) < 1) {
            throw new Error();
        }
        
        if (count($item->value) == 2) {
        $mystring = $this->evaluate($item->value[0]);
        $findme1 = $this ->evaluate($item->value[1]);
        return  trim(strtoupper(substr($mystring,strpos($mystring, $findme1)+strlen($findme1)+1))); 
        }
         else
        {
        $mystring = $this->evaluate($item->value[0]);
        $findme1 = $this->evaluate($item->value[1]);
        $findme2 = $this->evaluate($item->value[2]);
           $mystring1 = substr($mystring,strpos($mystring, $findme1)+strlen($findme1)+1);
        $pos = strpos($mystring1,$findme2) ;
        return trim(strtoupper(substr($mystring1,0,$pos))); 

        }  
        
    }
}
