<?php
namespace Espo\Custom\Hooks\Contact;

use Espo\ORM\Entity;

class Contact extends \Espo\Core\Hooks\Base
{
    protected function init()
    {
        parent::init();
        $this->addDependency('serviceFactory');
    }
    
    protected function getServiceFactory()
    {
         return $this->getInjection('serviceFactory');
    }

    public function afterSave(Entity $entity, array $options = array()){
        $recordId = $entity->get('id');        
        $entityManager = $this->getEntityManager();
	//file_put_contents('/var/www/espo/data/logs/contacts.log', print_r());
        $contact = $entityManager->getRepository('Contact')->where(array(
            'id' => $recordId, 
        ))->findOne();
	$bimsiCustomerId = $contact->get('bCustomerId');
	$contactLastUpdated = $contact->get('lastUpdated');
	file_put_contents('/var/www/espo/data/logs/contacts.log', print_r($contactLastUpdated, true));
	exit;
	//$aopenLastUpdated = $contact->get('lastUpdated');	

	$aopen = $entityManager->getRepository('AccountOpening')->where(array(
            'bimsiCode' => $bimsiCustomerId,
        ))->findOne();
	//foreach($aopen as $ao){
	$aopenLastUpdated = $aopen->get('lastUpdated');
        $relatedAOpen = $entityManager->getRepository('Contact')->findRelated($contact, 'accountOpenings');
	//$bAccounts = $entityManager->getRepository('BrokerageAccount')->findRelated($contact, 'accountOpenings');

	if(!isset($relatedAOpen) || is_null($relatedAOpen) || empty($relatedAOpen)){
		file_put_contents('/var/www/espo/data/logs/contacts.log', 'AO Not Existed');
		//$this->relateToContact($aopen, $contact);
	} else {
		file_put_contents('/var/www/espo/data/logs/contacts.log', 'AO Existed');
		$realationAOpenContact = $this->relateToContact($aopen, $contact);
        }

	/*if(!isset($bAccounts) || is_null($bAccounts) || empty($bAccounts)){
                file_put_contents('/var/www/espo/data/logs/contacts.log', 'AO Not Existed');
                //$this->relateToContact($aopen, $contact);
        } else {
                file_put_contents('/var/www/espo/data/logs/contacts.log', 'AO Existed');
                $realationAOpenBAccount = $this->relateToBAccount($aopen, $bAccounts);
        }*/

	if(!isset($aopenLastUpdated) || is_null($aopenLastUpdated) || empty($aopenLastUpdated)){
		file_put_contents('/var/www/espo/data/logs/contacts.log', 'Last Updated new');
		//$contact->set('lastUpdated', '');
	} else {
		file_put_contents('/var/www/espo/data/logs/contacts.log', 'Last Updated Existed');
		$contactEntity = $this->getEntityManager()->getEntity('Contact', $recordId);
		$contactEntity->set('lastUpdated', $aopenLastUpdated);
		$this->getEntityManager()->saveEntity($contactEntity);
		//$entityManager->saveEntity($contact);
		//$bAccounts->set('lastUpdated', $aopenLastUpdated);
	}
    }

    public function relateToContact($accountObjects, $contactObject){
        $entityManager = $this->getEntityManager();
	$contact = $entityManager->getRepository('Contact');
        //for($i = 0 ; $i< count($accountObjects) ; $i++){
	     //file_put_contents('/var/www/espo/data/logs/contacts.log', print_r($accountObjects[$i], true));
	     $contact->relate($contactObject, 'accountOpenings', $accountObjects);
        //}     
    }

    public function relateToBAccount($accountObjects, $bAccountObject){
        $entityManager = $this->getEntityManager();
	$bAccount = $entityManager->getRepository('BrokerageAccount');
        //for($i = 0 ; $i< count($accountObjects) ; $i++){
             //file_put_contents('/var/www/espo/data/logs/contacts.log', print_r($accountObjects[$i], true));
	     $bAccount->relate($bAccountObject, 'accountOpenings', $accountObjects);
        //}
    }
}

