<?php
namespace Espo\Custom\Hooks\AccountOpening;

use Espo\ORM\Entity;
use Espo\Custom\Hooks\MissingHandler;

class AccountOpening extends \Espo\Core\Hooks\Base
{
    //public static $order = 0;
    protected function init()
    {
        parent::init();
        $this->addDependency('serviceFactory');
    }
    
    protected function getServiceFactory()
    {
         return $this->getInjection('serviceFactory');
    }

    public function afterSave(Entity $entity, array $options = array())
    {
	file_put_contents('/var/www/espo/data/logs/aoLog.log', 'Welcome Waleed');
        $entityManager = $this->getEntityManager();
        //$missingHandler = new MissingHandler();
	//$accountType = $entity->get('accountType');
	//$subAttachedDocuments = $entity->get('subAttachedDocuments');
	file_put_contents('/var/www/espo/data/logs/aoLog.log', 'Welcome Waleed');//print_r($subAttachedDocuments, true));
	$selectedSubAttachedDocs = $entity->get('selectedSubAttachedDocs');
	if($accountType == "Institution"){
        	$missingHandler->verifyInstitutionalClients( $entity , $entityManager , 0);    
        	$missingHandler->verifyInvestmentPortfolios( $entity, $entityManager, 2);
        	$missingHandler->verifyPublicInstitutions( $entity, $entityManager, 3);
        	$missingHandler->verifyPublicInstitutionsList( $entity, $entityManager, 4);
        	$missingHandler->verifyNonProfitOrganization($entity, $entityManager, 8);
        	$missingHandler->verifyNonProfitOrganizationCharitiesList($entity, $entityManager, 9);
        	//$missingHandler->verifyCompaniesList($entity, $entityManager, 12);
        	$missingHandler->verifyInvestmentFunds($entity, $entityManager, 15);  
        	//$missingHandler->verifyInvestmentFundsList($entity, $entityManager, 16); 
	}
        else if ($accountType == "Retail" || $accountType == "Retail/Staff"){
		$missingHandler->verifySubAttachedEgyptKYC( $entity, $entityManager, 5);
	        $missingHandler->verifySubAttachedAdditionalInfo( $entity, $entityManager, 6);
        	$missingHandler->verifySalariedEmploymentProof( $entity, $entityManager, 7);
		$missingHandler->verifyApplicationFormSignatureList($entity, $entityManager, 17); 
	        $missingHandler->verifyBukAgreementsList($entity, $entityManager, 18);
	        $missingHandler->verifyApprovalEfsa($entity, $entityManager, 19); 
        	$missingHandler->verifyAddressProof($entity, $entityManager, 20);
		$missingHandler->verifyRequiresFatca($entity, $entityManager, 10);
	        $missingHandler->verifyFatcaDocumentations($entity, $entityManager, 11);	
		$missingHandler->verifySelfEmploymentProof($entity, $entityManager, 13);
	        $missingHandler->verifyPassportCopyBuk($entity, $entityManager, 14);
	}
    }
    /*public function beforeSave(Entity $entity, array $options = array())
    {

    }*/
}

