<?php
namespace Espo\Custom\Hooks\Document;

use Espo\ORM\Entity;

class Document extends \Espo\Core\Hooks\Base
{
    protected function init()
    {
        parent::init();
        $this->addDependency('serviceFactory');
    }
    
    protected function getServiceFactory()
    {
         return $this->getInjection('serviceFactory');
    }

    public function afterSave(Entity $entity, array $options = array()){
        $recordId = $entity->get('id');        
        $entityManager = $this->getEntityManager();
        $document = $entityManager->getRepository('Document')->where(array(
            'id' => $recordId,
        ))->findOne();
        
        // if ($entity->isNew()) {
        //     $document = $this->getEntityManager()->getEntity('Document', $recordId);
        //     // if (empty($entity->get('name'))) {
        //     //     // $team = $entity->get('teamsNames');
        //     //     // foreach ($team as $key => $value) {
        //     //     //     $teamName = $value;
        //     //     // }
        //     //     $document->set('name', $value);
        //     // }            
        //     $this->getEntityManager()->saveEntity($document);
        // }

        $accountOpening = $entityManager->getRepository('Document')->
                findRelated($document, 'accountOpenings');
        
        if(isset($accountOpening)) {
            for($i = 0; $i< count($accountOpening) ; $i++){
               $accountChildren = $this->returnChildrenAccountOpening($accountOpening[$i]->id);
                 $this->relateToDocument( $accountChildren, $document );    
            }
        }

    }

    public function returnChildrenAccountOpening($recordId)
    {
        $entityManager = $this->getEntityManager();
        $aopenEntity = $entityManager->getRepository('AccountOpening')->where(array(
            'id' => $recordId,    
        ))->findOne();

        $childrenAccounts = $entityManager->
            getRepository('AccountOpening')->findRelated($aopenEntity, 'accountOpenings');

        return $childrenAccounts;
    }

    public function relateToDocument($accountObjects, $documentObject)
    {
        $entityManager = $this->getEntityManager();
        for($i = 0; $i< count($accountObjects); $i++) {
             $entityManager->getRepository('Document')->relate($documentObject, 
                'accountOpenings', $accountObjects[$i]);
        }     
    }
}
