<?php
namespace Espo\Custom\Hooks\CashTransfers;

use Espo\ORM\Entity;

class CashTransfers extends \Espo\Core\Hooks\Base
{
    protected function init()
    {
        parent::init();
        $this->addDependency('serviceFactory');
    }
    
    protected function getServiceFactory()
    {
         return $this->getInjection('serviceFactory');
    }

    private function getCashType($key)
    {
        $data = [
            'cash_transfer'         => 'Cash Transfer',
            'cash_deposit'          => 'Cash Deposit',
            'cheque_issuance '      => 'Cheque Issuance ',
            ' internal_transfer'    => 'Internal Transfer',
        ];
        return $data[$key];
    }

    public function afterSave(Entity $entity, array $options = array())
    {
        $recordId = $entity->get('id');        
        $entityManager = $this->getEntityManager();
        $cashTransfer = $entityManager->getRepository('CashTransfers')->where(array(
            'id' => $recordId,    
        ))->findOne();
        
        if ($entity->isNew()) {
            $cashTransferTitle = $this->getEntityManager()->getEntity('CashTransfers', $recordId);
            if (empty($entity->get('name'))) {
                $cashType = $entity->get('cashType');
                $cashTransferTitle->set('name', $this->getCashType($cashType));
            }
            $this->getEntityManager()->saveEntity($cashTransferTitle);
        }
    }
}
