<?php
/*
namespace Espo\Custom\Hooks\AccountOpening;

use Espo\ORM\Entity;
use Espo\Core\Utils\Metadata;
use Espo\Core\Utils\Config;
use Espo\Core\Utils\File\Manager;
use Espo\Core\Utils\Util;

class MissingHandler
{
    CONST log = '/var/www/espocrm/data/logs/log.log';
    CONST log2 = '/var/www/espocrm/data/logs/log2.log';
    CONST log3 = '/var/www/espocrm/data/logs/log3.log';
    CONST fieldDef = '/var/www/espocrm/Espo/Custom/Resources/i18n/en_US/AccountOpening.json';

    protected function init()
    {
        parent::init(false);
        $this->addDependency('serviceFactory');
    }

    public function getFieldDef($fieldName)
    {
        $fileManager = new Manager();
        $config = new Config($fileManager);

        $metadata = new Metadata($config, $fileManager);
        $field = $metadata->get('entityDefs.AccountOpening.fields.' . $fieldName);
        return $field['options'];

    }

    public function relateToMissingLog($accountObjects, $missingLogObject, $entityManager)
    {
        $entityManager->getRepository('AccountOpening')->
        relate($accountObjects, 'missingLogs', $missingLogObject);
    }

    public function unrelateMissingLog($accountObjects, $missingLogObject, $entityManager)
    {
      
        $entityManager->getRepository('AccountOpening')->
        unrelate($accountObjects, 'missingLogs', $missingLogObject);
    }

    public function parentUnrelateMissingLog($parentId, $missingLogObject, $entityManager)
    {
        
        $accountObjects = $entityManager->getRepository('AccountOpening')->
        where(array(
            'id' => $parentId
        ))->findOne();

        $entityManager->getRepository('AccountOpening')->
        unrelate($accountObjects, 'missingLogs', $missingLogObject);
    }
    
    public function parentRelateToMissingLog($parentId, $missingLogObject, $entityManager)
    {
        $accountObjects = $entityManager->getRepository('AccountOpening')->
        where(array(
            'id' => $parentId
        ))->findOne();

        $entityManager->getRepository('AccountOpening')->
        relate($accountObjects, 'missingLogs', $missingLogObject);
    }

    public function verifyInstitutionalClients($entity, $entityManager, $logNumber)
    {
        $accountType = $entity->get('accountType');
        $institutionalClients = $entity->get('institutionalClients');
        $parentaccountOpeningId = $entity->get('parentaccountOpeningId');
        $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, 
            'Institutional Clients');

        if (empty($currentMissingLog)) {
            $this->insertQuery($entityManager, array('name' => 'Institutional Clients',
                 'log_number' => $logNumber));
            $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, 
            'Institutional Clients');
        }        
        if ($accountType != 'Institution' || $institutionalClients == 1){
            $this->unrelateMissingLog($entity, $currentMissingLog, $entityManager);
            $this->parentUnrelateMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);
        } else {
            $this->relateToMissingLog($entity, $currentMissingLog, $entityManager);
            $this->parentRelateToMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);
        }
    }

    public function verifyPublicInstitutions($entity, $entityManager, $logNumber)
    {
		$accountType = $entity->get('accountType');
        $publicInstitution = $entity->get('institutionAndGovernmental');
        $institutionalClients = $entity->get('institutionalClients');
        $parentaccountOpeningId = $entity->get('parentaccountOpeningId');
        $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, 'Public Institution & governmental departments:');
        if (empty($currentMissingLog)) {
            $this->insertQuery($entityManager, array('name' => 'Public Institution & governmental departments:',
                'log_number' => $logNumber));
            $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, 'Public Institution & governmental departments:');
        }

        
        if ($accountType != 'Institution' || $publicInstitution == 1 || $institutionalClients == 1) {
            $this->unrelateMissingLog($entity, $currentMissingLog, $entityManager);
            $this->parentUnrelateMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);
        } else {
            $this->relateToMissingLog($entity, $currentMissingLog, $entityManager);
            $this->parentRelateToMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);
        }
    }
    
   public function verifyFatcaDocumentations($entity, $entityManager, $logNumber)
    {
        $accountType = $entity->get('accountType');
        $fatcaDocumentations = $entity->get('fatcaDocumentations');
        $fatca = $entity->get('fatca');
        $subAttachedDocuments = $entity->get('subAttachedDocuments');
        $parentaccountOpeningId = $entity->get('parentaccountOpeningId');
        $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber,
            'FATCA Documentations');

        $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, 'FATCA Documentations');
        if (empty($currentMissingLog) && $fatca == 1) {
            $this->insertQuery($entityManager, array('name' => 'FATCA Documentations',
                'log_number' => $logNumber));
            $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber,
                'FATCA Documentations');
        }
        if ( (empty($fatcaDocumentations) && $fatca == 1)  &&
            ($accountType == 'Retail' || $accountType == 'Retail/Staff')) {
            $this->relateToMissingLog($entity, $currentMissingLog, $entityManager);
            $this->parentRelateToMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);
        } else {
            $this->unrelateMissingLog($entity, $currentMissingLog, $entityManager);
            $this->parentUnrelateMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);
        }
    }

    public function verifyPublicInstitutionsList($entity, $entityManager, $logNumber)
    {
        $publicInstitutionListDef = $this->getFieldDef('institutionsAndGovernmentalDepartments');
        $publicInstitutionList = $entity->get('institutionsAndGovernmentalDepartments');
        $publicInstitution = $entity->get('institutionAndGovernmental');
        $accountType = $entity->get('accountType');

        if ($accountType != 'Institution') {
            $GLOBALS['log']->notice('AccountOpening: verifyPublicInstitutionsList => Applied only with Institutional Account .');
            return;
        }
        if ($publicInstitution == 0) {
            $GLOBALS['log']->notice('AccountOpening: verifyPublicInstitutionsList => dependent fields(Public Institution & governmental departments) not set .');
            return;
        } else {
            if (!empty(publicInstitutionListDef))
                for ($def = 0; $def < count($publicInstitutionListDef); $def++) {
                    $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, $publicInstitutionListDef[$def]);
                    if (empty($currentMissingLog)) {
                        $this->insertQuery($entityManager, array('name' => $publicInstitutionListDef[$def], 'log_number' => $logNumber));
                        $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, $publicInstitutionListDef[$def]);
                    }
                    if (!in_array($publicInstitutionListDef[$def], $publicInstitutionList))
                        $this->relateToMissingLog($entity, $currentMissingLog, $entityManager);
                    else
                        $this->unrelateMissingLog($entity, $currentMissingLog, $entityManager);

                }
        }
    }


    public function verifySubAttachedEgyptKYC($entity, $entityManager, $logNumber)
    {

        $subAttachedDocs = $entity->get('subAttachedDocuments');
        $bsbAgreement = $entity->get('bsbAgreement');
        $bshAgreement = $entity->get('bshAgreement');

        $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, 'Egypt KYC form');
        if (empty($currentMissingLog)) {
            $this->insertQuery($entityManager, array('name' => 'Egypt KYC form', 'log_number' => $logNumber));
            $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, 'Egypt KYC form');
        }

        if (empty($subAttachedDocs) && bsbAgreement == 0 && bshAgreement == 0) {
            $GLOBALS['log']->notice('AccountOpening: verifySubAttachedEgyptKYC => Dependent fields(Sub Attached Documents , BSB Agreement, BSH Agreement) not set .');
            return;
        } else {
            if (in_array('Egypt KYC form', $subAttachedDocs) && (bsbAgreement == 1 || bshAgreement == 1))
                $this->unrelateMissingLog($entity, $currentMissingLog, $entityManager);
            else
                $this->relateToMissingLog($entity, $currentMissingLog, $entityManager);
        }
    }

    public function verifySubAttachedAdditionalInfo($entity, $entityManager, $logNumber)
    {

        $subAttachedDocs = $entity->get('subAttachedDocuments');
        $bsbAgreement = $entity->get('bsbAgreement');
        $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, 'Additional Information');
        if (empty($currentMissingLog)) {
            $this->insertQuery($entityManager, array('name' => 'Additional Information', 'log_number' => $logNumber));
            $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, 'Additional Information');
        }

        if (empty($subAttachedDocs) && bsbAgreement) {
            $GLOBALS['log']->notice('AccountOpening: verifySubAttachedAdditionalInfo => Dependent fields(Sub Attached Documents , BSB Agreement) not set .');
            return;
        } else {
            if (in_array('Additional Information', $subAttachedDocs) && $bsbAgreement == 1)
                $this->unrelateMissingLog($entity, $currentMissingLog, $entityManager);
            else
                $this->relateToMissingLog($entity, $currentMissingLog, $entityManager);
        }
    }

    public function verifyBukAgreementsList($entity, $entityManager, $logNumber)
    {
        $bukAgreement = $entity->get('bukAgreement');
        $bukAgreementsListDef = $this->getFieldDef('bukAgreements');
        $bukAgreementsList = $entity->get('bukAgreements');
        $parentId = $entity->get('parentaccountOpeningId');
    
            if (!empty($bukAgreementsListDef))
                for ($def = 0; $def < count($bukAgreementsListDef); $def++) {
                    $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, $bukAgreementsListDef[$def]);
                    if (empty($currentMissingLog)) {
                        $this->insertQuery($entityManager, array('name' => $bukAgreementsListDef[$def], 'log_number' => $logNumber));
                        $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, $bukAgreementsListDef[$def]);
                    }
                    if (!in_array($bukAgreementsListDef[$def], $bukAgreementsList) && $bukAgreement == 1){
                        $this->relateToMissingLog($entity, $currentMissingLog, $entityManager);
                        $this->parentRelateToMissingLog($parentId, $missingLogObject, $entityManager);
                    }else{
                        $this->unrelateMissingLog($entity, $currentMissingLog, $entityManager);
                        $this->parentUnrelateMissingLog($parentId, $missingLogObject, $entityManager);
                    }    
                }
        
    }


    public function verifyApplicationFormSignatureList($entity, $entityManager, $logNumber)
    {
        $accountType = $entity->get('accountType');
        $applicationFormSignatureListDef = $this->getFieldDef('applicationFormSignature');
        $applicationFormSignatureList = $entity->get('applicationFormSignature');
        $parentId = $entity->get('parentaccountOpeningId');
    
            if (!empty($applicationFormSignatureListDef))
                for ($def = 0; $def < count($applicationFormSignatureListDef); $def++) {
                    $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, $applicationFormSignatureListDef[$def]);
                    if (empty($currentMissingLog)) {
                        $this->insertQuery($entityManager, array('name' => $applicationFormSignatureListDef[$def], 'log_number' => $logNumber));
                        $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, $applicationFormSignatureListDef[$def]);
                    }
                    if (!in_array($applicationFormSignatureListDef[$def], $applicationFormSignatureList) && $accountType != 'Institution'){
                        
                        $this->relateToMissingLog($entity, $currentMissingLog, $entityManager);
                        $this->parentRelateToMissingLog($parentId, $missingLogObject, $entityManager);
                    }else{
                        
                        $this->unrelateMissingLog($entity, $currentMissingLog, $entityManager);
                        $this->parentUnrelateMissingLog($parentId, $missingLogObject, $entityManager);
                    }    
                }
        
    }

    public function verifyInvestmentFunds($entity, $entityManager, $logNumber)
    {
        $accountType = $entity->get('accountType');
        $institutionalClients = $entity->get('institutionalClients');
        $investmentFundsPortfolios = $entity->get('investmentFundsPortfolios');
        $parentaccountOpeningId = $entity->get('parentaccountOpeningId');

        $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, 
            'Investment Funds & Portfolios');

        if (empty($currentMissingLog)) {
            $this->insertQuery($entityManager, array('name' => 'Investment Funds & Portfolios',
                 'log_number' => $logNumber));
            $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, 
            'Investment Funds & Portfolios');
        }        
        if ($accountType != 'Institution' || $investmentFundsPortfolios == 1 || $institutionalClients == 1){
            $this->unrelateMissingLog($entity, $currentMissingLog, $entityManager);
            $this->parentUnrelateMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);
        } else {
            $this->relateToMissingLog($entity, $currentMissingLog, $entityManager);
            $this->parentRelateToMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);
        }
    }

    public function verifyInvestmentFundsList($entity, $entityManager, $logNumber)
    {
        $accountType = $entity->get('accountType');
        $investmentFundsPortfolios = $entity->get('investmentFundsPortfolios');
        $investmentFundsListDef = $this->getFieldDef('investmentFunds');
        $investmentFundsList = $entity->get('investmentFunds');
        $parentId = $entity->get('parentaccountOpeningId');
    
            if (!empty($investmentFundsListDef))
                for ($def = 0; $def < count($investmentFundsListDef); $def++) {
                    $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, $investmentFundsListDef[$def]);
                    if (empty($currentMissingLog)) {
                        $this->insertQuery($entityManager, array('name' => $investmentFundsListDef[$def], 'log_number' => $logNumber));
                        $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, $investmentFundsListDef[$def]);
                    }
                    if (!in_array($investmentFundsListDef[$def], $investmentFundsList) && $accountType == 'Institution' && $investmentFundsPortfolios ==1 ){
                        
                        $this->relateToMissingLog($entity, $currentMissingLog, $entityManager);
                        $this->parentRelateToMissingLog($parentId, $missingLogObject, $entityManager);
                    }else{
                        
                        $this->unrelateMissingLog($entity, $currentMissingLog, $entityManager);
                        $this->parentUnrelateMissingLog($parentId, $missingLogObject, $entityManager);
                    }    
                }
        
    }


    public function verifyInvestmentPortfolios($entity, $entityManager, $logNumber)
    {
        $accountType = $entity->get('accountType');
        $investmentFundsPortfolios = $entity->get('investmentFundsPortfolios');
        $investmentPortfoliosListDef = $this->getFieldDef('investmentPortfolios');
        $investmentPortfoliosList = $entity->get('investmentPortfolios');
        $parentId = $entity->get('parentaccountOpeningId');
    
            if (!empty($investmentPortfoliosListDef))
                for ($def = 0; $def < count($investmentPortfoliosListDef); $def++) {
                    $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, $investmentPortfoliosListDef[$def]);
                    if (empty($currentMissingLog)) {
                        $this->insertQuery($entityManager, array('name' => $investmentPortfoliosListDef[$def], 'log_number' => $logNumber));
                        $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, $investmentPortfoliosListDef[$def]);
                    }
                    if (!in_array($investmentPortfoliosListDef[$def], $investmentPortfoliosList) && $accountType == 'Institution' && $investmentFundsPortfolios ==1 ){
                        
                        $this->relateToMissingLog($entity, $currentMissingLog, $entityManager);
                        $this->parentRelateToMissingLog($parentId, $missingLogObject, $entityManager);
                    }else{
                        
                        $this->unrelateMissingLog($entity, $currentMissingLog, $entityManager);
                        $this->parentUnrelateMissingLog($parentId, $missingLogObject, $entityManager);
                    }    
                }
        
    }

    public function insertQuery($entityManager, $data)
    {

        $pdo = $entityManager->getPDO();
        $util = new Util();
        $id = $util->generateId();

        $sql = 'INSERT INTO `missing_log`(id,`name`,log_number) values ("' . $id . '","' . $data['name'] . '","' . $data['log_number'] . '")';

        $sth = $pdo->prepare($sql);
        $sth->execute();
    }

    public function getCurrentLog($entityManager, $logNumber, $name)
    {
        $missingLogEntity = $entityManager->getRepository('MissingLog')->
        where(array(
            'logNumber' => $logNumber,
            'name' => $name
        ))->findOne();

        return $missingLogEntity->id;
    }
 	
    public function verifyNonProfitOrganization($entity, $entityManager, $logNumber)    
    {
        $accountType = $entity->get('accountType');
        $institutionalClients = $entity->get('institutionalClients');
        $nonProfitOrganization = $entity->get('nonProfitOrganizationCharities');
        $parentaccountOpeningId = $entity->get('parentaccountOpeningId');
        $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber,
            'Institutional Clients');

        if (empty($currentMissingLog)) {
            $this->insertQuery($entityManager, array('name' => 'Non-profit Organization & charities',
                'log_number' => $logNumber));
            $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber,
                'Non-profit Organization & charities');
        }

        if ($accountType != 'Institution' || $nonProfitOrganization == 1 || $institutionalClients == 1 ) {
            $this->unrelateMissingLog($entity, $currentMissingLog, $entityManager);
            $this->parentUnrelateMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);
        } else {
            $this->relateToMissingLog($entity, $currentMissingLog, $entityManager);
            $this->parentRelateToMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);
        }
    }

    public function verifyNonProfitOrganizationCharitiesList($entity, $entityManager, $logNumber)
    {
	$nonProfitOrganization = $entity->get('nonProfitOrganizationCharities');
	$nonProfitOrganizationListDef = $this->getFieldDef('nonProfitOrganizationCharitiesList');
        $nonProfitOrganizationList = $entity->get('nonProfitOrganizationCharitiesList');
        $accountType = $entity->get('accountType');
	$parentaccountOpeningId = $entity->get('parentaccountOpeningId');
       
        if (! empty($nonProfitOrganizationListDef))
                for ($def = 0; $def < count($nonProfitOrganizationListDef); $def++) {
                    $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, $nonProfitOrganizationListDef[$def]);
                    if (empty($currentMissingLog)) {
                        $this->insertQuery($entityManager, array('name' => $nonProfitOrganizationListDef[$def], 'log_number' => $logNumber));
                        $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, $nonProfitOrganizationListDef[$def]);
                    }
                    if (!in_array($nonProfitOrganizationListDef[$def], $nonProfitOrganizationList) && $nonProfitOrganization == 1 && $accountType == 'Institution' ){
                        $this->relateToMissingLog($entity, $currentMissingLog, $entityManager);
						$this->parentRelateToMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);

                    }else{
                        $this->unrelateMissingLog($entity, $currentMissingLog, $entityManager);
					    $this->parentUnrelateMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);

					}	
                }
        
    }
    
    public function verifyRequiresFatca($entity, $entityManager, $logNumber)
    {
        $accountType = $entity->get('accountType');
        $fatca = $entity->get('fatca');
        $parentaccountOpeningId = $entity->get('parentaccountOpeningId');
        $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber,
            'Requires FATCA');

        if (empty($currentMissingLog)) {
            $this->insertQuery($entityManager, array('name' => 'Requires FATCA',
                'log_number' => $logNumber));
            $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber,
                'Requires FATCA');
        }

        if ($accountType != 'Institution' || $fatca == 1) {
            $this->unrelateMissingLog($entity, $currentMissingLog, $entityManager);
            $this->parentUnrelateMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);
        } else {
            $this->relateToMissingLog($entity, $currentMissingLog, $entityManager);
            $this->parentRelateToMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);
        }
    }

    public function verifyCompaniesList($entity, $entityManager, $logNumber)
    {
        $companiesListDef = $this->getFieldDef('companies');
        $companiesList = $entity->get('companies');
        $institutionClients = $entity->get('institutionalClients');
        $accountType = $entity->get('accountType');
        $parentaccountOpeningId = $entity->get('parentaccountOpeningId');

        if (!empty($companiesListDef))
            for ($def = 0; $def < count($companiesListDef); $def++) {
                $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, $companiesListDef[$def]);
                if (empty($currentMissingLog)) {
                    $this->insertQuery($entityManager, array('name' => $companiesListDef[$def], 'log_number' => $logNumber));
                    $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, $companiesListDef[$def]);
                }
                if (!in_array($companiesListDef[$def], $companiesList) && $institutionClients == 1 && $accountType == 'Institution') {
                    $this->relateToMissingLog($entity, $currentMissingLog, $entityManager);
                    $this->parentRelateToMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);
                } else {
                    $this->unrelateMissingLog($entity, $currentMissingLog, $entityManager);
                    $this->parentUnrelateMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);
                }
            }
    }

    public function verifyAddressProof($entity, $entityManager, $logNumber)
    {
        $addressProof = $entity->get('addressProof');
        $parentaccountOpeningId = $entity->get('parentaccountOpeningId');
        $accountType = $entity->get('accountType');

        $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, 'Address Proof');
        if (empty($currentMissingLog)) {
            $this->insertQuery($entityManager, array('name' => 'Address Proof',
                'log_number' => $logNumber));
            $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, 'Address Proof');
        }
        if (count($addressProof) == 0 &&
         ($accountType == 'Retail' || $accountType == 'Retail/Staff')) {
            $this->relateToMissingLog($entity, $currentMissingLog, $entityManager);
            $this->parentRelateToMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);
        } else {
            $this->unrelateMissingLog($entity, $currentMissingLog, $entityManager);
            $this->parentUnrelateMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);
        }
    }

    public function verifyPassportCopyBuk($entity, $entityManager, $logNumber)
    {
        $accountType = $entity->get('accountType');
        $passportCopyBuk = $entity->get('passportCopyBuk');
        $parentaccountOpeningId = $entity->get('parentaccountOpeningId');
        $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber,
            'Passport Copy (required for BUK)');

        if (empty($currentMissingLog)) {
            $this->insertQuery($entityManager, array('name' => 'Passport Copy (required for BUK)',
                'log_number' => $logNumber));
            $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber,
                'Passport Copy (required for BUK)');
        }

        if ($accountType != 'Retail/Staff' || $passportCopyBuk == 1) {
            $this->unrelateMissingLog($entity, $currentMissingLog, $entityManager);
            $this->parentUnrelateMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);
        } else {
            $this->relateToMissingLog($entity, $currentMissingLog, $entityManager);
            $this->parentRelateToMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);
        }
    }

    public function verifyApprovalEfsa($entity, $entityManager, $logNumber)
    {
        $accountType = $entity->get('accountType');
        $approvalFromEFSA = $entity->get('approvalFromEFSA');
        $parentaccountOpeningId = $entity->get('parentaccountOpeningId');
        $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber,
            'Approval EFSA');

        if (empty($currentMissingLog)) {
            $this->insertQuery($entityManager, array('name' => 'Approval EFSA',
                'log_number' => $logNumber));
            $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber,
                'Approval EFSA');
        }

        if ($accountType != 'Retail/Staff' || $approvalFromEFSA == 1) {
            $this->unrelateMissingLog($entity, $currentMissingLog, $entityManager);
            $this->parentUnrelateMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);
        } else {
            $this->relateToMissingLog($entity, $currentMissingLog, $entityManager);
            $this->parentRelateToMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);
        }
    }

    public function verifySalariedEmploymentProof($entity, $entityManager, $logNumber)
    {
        $accountType = $entity->get('accountType');
        $salariedEmploymentProof = $entity->get('salariedEmploymentProof');
        $selfEmploymentProof = $entity->get('selfEmploymentProof');
        $parentaccountOpeningId = $entity->get('parentaccountOpeningId');
        $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber,
            'Salaried Employment Proof');
        if (empty($currentMissingLog)) {
            $this->insertQuery($entityManager, array('name' => 'Salaried Employment Proof',
                'log_number' => $logNumber));
            $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber,
                'Salaried Employment Proof');
        }    

        if ($accountType == 'Institution'
            || (! empty($salariedEmploymentProof) || ! empty($selfEmploymentProof)) ) {
            $this->unrelateMissingLog($entity, $currentMissingLog, $entityManager);
            $this->parentUnrelateMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);
        } else {
            $this->relateToMissingLog($entity, $currentMissingLog, $entityManager);
            $this->parentRelateToMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);
        }
        
    }

    public function verifySelfEmploymentProof($entity, $entityManager, $logNumber)
    {
        $accountType = $entity->get('accountType');
        $selfEmploymentProof = $entity->get('selfEmploymentProof');
        $parentaccountOpeningId = $entity->get('parentaccountOpeningId');
        $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber,
            'Self Employment Proof');
        $salariedEmploymentProof = $entity->get('salariedEmploymentProof');
        $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber, 'Self Employment Proof');
        if (empty($currentMissingLog)) {
            $this->insertQuery($entityManager, array('name' => 'Self Employment Proof',
                'log_number' => $logNumber));
            $currentMissingLog = $this->getCurrentLog($entityManager, $logNumber,
             'Self Employment Proof');
        }
        if ( ( empty($selfEmploymentProof) && empty($salariedEmploymentProof) ) 
            && ($accountType == 'Retail' || $accountType == 'Retail/Staff') ) {
            $this->relateToMissingLog($entity, $currentMissingLog, $entityManager);
            $this->parentRelateToMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);
        } else {
            $this->unrelateMissingLog($entity, $currentMissingLog, $entityManager);
            $this->parentUnrelateMissingLog($parentaccountOpeningId, $currentMissingLog, $entityManager);
        }
    }
}
*/
