<?php
namespace Espo\Custom\Hooks\WorkLog;

use Espo\ORM\Entity;

class WorkLog extends \Espo\Core\Hooks\Base
{
    protected function init()
    {
        parent::init();
        $this->addDependency('serviceFactory');
    }
    
    protected function getServiceFactory()
    {
         return $this->getInjection('serviceFactory');
    }

    public function afterSave(Entity $entity, array $options = array()){
        $recordId = $entity->get('id');        
        $entityManager = $this->getEntityManager();
        $workLog = $entityManager->getRepository('WorkLog')->where(array(
            'id' => $recordId,    
        ))->findOne();
        
        if ($entity->isNew()) {
            $workLogTitle = $this->getEntityManager()->getEntity('WorkLog', $recordId);
            if (empty($entity->get('name'))) {
                $team = $entity->get('teamsNames');
                foreach ($team as $key => $value) {
                    $teamName = $value;
                }
                $workLogTitle->set('name', $value);
            }            
            $this->getEntityManager()->saveEntity($workLogTitle);
        }

        $accountOpening = $entityManager->getRepository('WorkLog')->
                findRelated($workLog, 'accountOpenings');
        
        if(isset($accountOpening)){
            for($i = 0 ; $i< count($accountOpening) ; $i++){
               $accountChildren = $this->
                     returnChildrenAccountOpening($accountOpening[$i]->id);
                 $this->relateToWorklog( $accountChildren, $workLog );    
            }
        }

    }

    public function returnChildrenAccountOpening($recordId){
        $entityManager = $this->getEntityManager();
        $aopenEntity = $entityManager->getRepository('AccountOpening')->where(array(
            'id' => $recordId,    
        ))->findOne();

        $childrenAccounts = $entityManager->
            getRepository('AccountOpening')->findRelated($aopenEntity, 'accountOpenings');

        return $childrenAccounts;
    }

    public function relateToWorklog($accountObjects, $workLogObject){
        $entityManager = $this->getEntityManager();
        for($i = 0 ; $i< count($accountObjects) ; $i++){
             $entityManager->getRepository('WorkLog')->relate($workLogObject, 
                'accountOpenings', $accountObjects[$i]);
        }     
    }
}
