<?php

class AfterUninstall {

    protected $container;

    public function run($container) {
        $this->container = $container;
        $config = $this->container->get('config');

        $tabList = $config->get('tabList', []);

        foreach ($tabList as $i => $item) {
            if ($item == 'Nextcloud') {
                unset($tabList[$i]);
            }
        }
        $tabList = array_values($tabList);

        $config->set('tabList', $tabList);

        $config->save();

        $this->clearCache();
    }

    protected function clearCache() {
        try {
            $this->container->get('dataManager')->clearCache();
        } catch (\Exception $e) {}
    }
}
