<?php

include "bootstrap.php";

$app = new \Espo\Core\Application();

$config = $app->getContainer()->get('config');
$entityManager = $app->getContainer()->get('entityManager');
$metadata = $app->getContainer()->get('metadata');

$user = $entityManager->getEntity('User', 'system');
$entityManager->setUser($user);
$app->getContainer()->setUser($user);

$pdo = $entityManager->getPDO();

$emailIdsQuery = 
"
SELECT campaign_log_record.object_id AS emailId 
FROM campaign_log_record 
INNER JOIN 
    (SELECT  MIN(id) minid, action,string_data, campaign_id, parent_id, parent_type, object_type, object_id
     FROM campaign_log_record
     WHERE deleted=0 AND application='MailChimp' AND object_type='Email' AND action='Sent'
     GROUP BY string_data, campaign_id, parent_id, parent_type
     HAVING COUNT(*) > 1) AS duplicates
   ON (duplicates.action = campaign_log_record.action
   AND duplicates.string_data = campaign_log_record.string_data
   AND duplicates.campaign_id = campaign_log_record.campaign_id
   AND duplicates.parent_id = campaign_log_record.parent_id
   AND duplicates.parent_type = campaign_log_record.parent_type

   AND duplicates.minid <> campaign_log_record.id)
WHERE campaign_log_record.object_id IS NOT NULL";

$sth = $pdo->prepare($emailIdsQuery);
$sth->execute();

$res = $sth->fetchAll(\PDO::FETCH_ASSOC);

foreach($res as $row) {
    $email = $entityManager->getEntity('Email', $row['emailId']);
    if (!empty($email)) {
        $entityManager->removeEntity($email);
    }
}

$emptySent = 
"DELETE FROM campaign_log_record 
WHERE application='Espo' AND object_id IS NULL AND queue_item_id IS NULL AND `action`='Sent'";

$sth = $pdo->prepare($emptySent);
$sth->execute();

echo "<br>" . "Duplicated Emails are deleted";

$deleteQuery = 
    "DELETE campaign_log_record
    FROM campaign_log_record
    INNER JOIN 
        (SELECT  MIN(id) minid, action, string_data, campaign_id, parent_id, parent_type, string_additional_data
         FROM campaign_log_record
         WHERE deleted=0 AND application='MailChimp'
         GROUP BY action, string_data, campaign_id, parent_id, parent_type, string_additional_data
         HAVING COUNT(*) > 1) AS duplicates
       ON (duplicates.action = campaign_log_record.action
       
       AND duplicates.campaign_id = campaign_log_record.campaign_id
       AND duplicates.parent_id = campaign_log_record.parent_id
       AND duplicates.parent_type = campaign_log_record.parent_type
       AND (duplicates.string_data = campaign_log_record.string_data OR (duplicates.string_data IS NULL AND campaign_log_record.string_data IS NULL))
       AND (duplicates.string_additional_data = campaign_log_record.string_additional_data OR (duplicates.string_additional_data IS NULL AND campaign_log_record.string_additional_data IS NULL))
       
       AND duplicates.minid <> campaign_log_record.id)
";

$sth = $pdo->prepare($deleteQuery);
$sth->execute();

echo "<br>" . "Duplicated Logs are deleted";
echo "<br>" . "Done";
