<?php

use Espo\Core\Container;
use Espo\Core\Utils\Config\ConfigWriter;

class AfterUninstall
{
    public function run(Container $container): void
    {
        // 1. Konfiguration bereinigen
        $configWriter = $container->get('injectableFactory')->create(ConfigWriter::class);
        
        // Wir setzen die Config-Parameter auf null, um sie aus der data/config.php zu entfernen
        $configWriter->set('shRecalculateEntityList', null);
        $configWriter->save();

        // 2. Modul-Ordner definieren (relativ zum Espo-Installationsverzeichnis)
        $baseDir = dirname(dirname(__DIR__)); // Springt aus scripts/ zurück ins Root
        
        $modulePath = 'custom/Espo/Modules/SHRecalculate';
        $clientPath = 'client/custom/modules/sh-recalculate';

        // 3. Rekursives Löschen ausführen
        $this->deleteDirectory($modulePath);
        $this->deleteDirectory($clientPath);

        // Der Metadaten-Cache wird in v9 automatisch durch den Installer 
        // am Ende des Deinstallationsprozesses bereinigt. 
        // Ein manueller Aufruf von Metadata::flush() ist nicht nötig und führt zum Fehler.
    }

    /**
     * Hilfsmethode zum rekursiven Löschen eines Ordners samt Inhalt
     */
    private function deleteDirectory(string $dir): bool
    {
        if (!file_exists($dir)) {
            return true;
        }

        if (!is_dir($dir)) {
            return unlink($dir);
        }

        foreach (scandir($dir) as $item) {
            if ($item == '.' || $item == '..') {
                continue;
            }

            // Rekursiver Aufruf
            if (!$this->deleteDirectory($dir . DIRECTORY_SEPARATOR . $item)) {
                return false;
            }
        }

        // Erst wenn der Ordner leer ist, kann er gelöscht werden
        return rmdir($dir);
    }
}