<?php

namespace Espo\Modules\SHRecalculate\Controllers;

use Espo\Core\Api\Request;
use Espo\Core\Api\Response;

class RecalculateFormula extends \Espo\Core\Templates\Controllers\Base
{
    public function getActionEnabledEntities(Request $request): array
    {
        // Wir holen die Liste und erzwingen ein leeres Array, falls null zurückkommt
        $enabledEntities = $this->getConfig()->get('shRecalculateEntityList');

        return is_array($enabledEntities) ? $enabledEntities : [];
    }

    public function postActionRecalculateFormula(Request $request, Response $response): bool
    {
        $data = $request->getParsedBody();

        if (empty($data->entityType) || empty($data->id)) {
            return false;
        }

        // Aufruf des Services (achte auf den korrekten Klassennamen SHRecalculate)
        return $this->getRecordService('SHRecalculate')->recalculate($data->entityType, $data->id);
    }
}