define('sh-recalculate:views/admin/sh-recalculate-settings', ['views/settings/record/edit'], function (Dep) {

    return class extends Dep {

        setup() {
            const metadata = this.getMetadata();

            if (metadata) {
                // Alle Scopes holen, die echte Objekte sind
                const scopeList = metadata.getScopeList().filter(scope => {
                    return metadata.get(['scopes', scope, 'object']);
                }).sort((a, b) => {
                    const labelA = this.translate(a, 'scopeNamesPlural', 'Global');
                    const labelB = this.translate(b, 'scopeNamesPlural', 'Global');
                    return labelA.localeCompare(labelB);
                });

                // Optionen direkt in die Laufzeit-Metadaten für das Feld schreiben
                const fieldMeta = metadata.get(['entityDefs', 'Settings', 'fields', 'shRecalculateEntityList']);
                if (fieldMeta) {
                    fieldMeta.options = scopeList;
                }
            }

            // Das Layout wird hier direkt im Code definiert, 
            // daher brauchen wir keine .tpl Datei!
            this.detailLayout = [
                {
                    rows: [
                        [
                            { name: 'shRecalculateEntityList' },
                            false
                        ]
                    ]
                }
            ];

            super.setup();
        }

        // Header-Titel anpassen
        getHeader() {
            return this.translate('SHRecalculate', 'labels', 'SHRecalculate');
        }
    };
});