define('sh-recalculate:setup-handler', [], function () {
    return class {
        process(view) {
            if (!view.model || !view.scope || view.scope !== view.model.name) return;

            Espo.Ajax.getRequest('RecalculateFormula/action/enabledEntities')
                .then(enabledEntities => {
                    if (Array.isArray(enabledEntities) && enabledEntities.includes(view.scope)) {
                        this.injectButton(view);
                    }
                })
                .catch(err => console.error("SH-Recalculate: Fehler beim Laden der Config", err));
        }

        injectButton(view) {
            view.actionRecalculateFormula = () => this.runRecalculation(view);

            const inject = () => {
                // Selektor für alle möglichen Button-Container
                const $header = view.$el.find('.header-buttons, .detail-buttons, .buttons-container, .panel-actions').first();
                
                if ($header.length && !$header.find('[data-name="recalculateFormula"]').length) {
                    const label = view.translate('recalculateFormula', 'labels', 'SHRecalculate');
                    
                    const $btn = $(`
                        <button class="btn btn-danger action radius-left radius-Right" type="button" data-action="recalculateFormula" data-name="recalculateFormula" style="margin-right: 5px; font-weight: bold;">
                            <span class="label-text">${label && label !== 'recalculateFormula' ? label : 'Neuberechnen'}</span>
                        </button>
                    `);

                    $header.prepend($btn);
                }
            };

            // 1. Sofortige Versuche bei Initialisierung
            inject();
            setTimeout(inject, 50);
            setTimeout(inject, 500);

            // 2. Auf View-Events reagieren (on statt once)
            view.on('render after:render cancel:edit record:readMode', () => {
                setTimeout(inject, 100);
            });

            // 3. Auf Model-Synchronisierung reagieren
            view.listenTo(view.model, 'sync change', () => {
                setTimeout(inject, 150);
            });

            // 4. Globaler MutationObserver (beobachtet das Hauptlayout)
            if (window.MutationObserver) {
                const observer = new MutationObserver(() => {
                    // Falls die View noch im DOM ist, Button prüfen
                    if (document.body.contains(view.el)) {
                        inject();
                    }
                });

                // Wir beobachten das Haupt-Element, da view.el beim Moduswechsel getauscht werden kann
                const mainEl = document.getElementById('main') || document.body;
                observer.observe(mainEl, { childList: true, subtree: true });

                // Aufräumen, wenn die View geschlossen wird
                view.once('remove', () => observer.disconnect());
            }

            // 5. Sicherheits-Intervall (Letzte Verteidigungslinie alle 2 Sek.)
            const interval = setInterval(inject, 2000);
            view.once('remove', () => clearInterval(interval));
        }

        runRecalculation(view) {
            Espo.Ui.notify(view.translate('recalculationInProgress', 'messages', 'SHRecalculate') || 'Berechne...');
            
            Espo.Ajax.postRequest('RecalculateFormula/action/recalculateFormula', {
                id: view.model.id,
                entityType: view.model.name
            }).then(() => {
                view.model.fetch().then(() => {
                    Espo.Ui.notify(false);
                    Espo.Ui.success(view.translate('recalculationSuccess', 'messages', 'SHRecalculate') || 'Erfolgreich');
                    // Nach dem Laden der Daten den Button nochmals sicherstellen
                    setTimeout(inject, 100);
                });
            }).catch(() => {
                Espo.Ui.notify(false);
            });
        }
    };
});