define('sh-recalculate:handlers/recalculate-handler', ['action-handler'], function (Dep) {

    return Dep.extend({

        actionRecalculateFormula: function (data, e) {
            const model = data.model;
            
            // 1. Einfaches Feedback ohne Übersetzungssystem
            alert("Anfrage gestartet für: " + model.name + " ID: " + model.id);

            // API Aufruf
            Espo.Ajax.post(model.name + '/action/recalculateFormula', {
                id: model.id
            }).then(response => {
                // 2. Model aktualisieren
                model.fetch().then(() => {
                    alert("Erfolg! Werte wurden aktualisiert.");
                });
            }).catch(xhr => {
                alert("Fehler vom Server: " + xhr.status);
                console.error(xhr);
            });
        }
    });
});