<?php

use Espo\Core\Container;
use Espo\Core\Utils\Config\ConfigWriter;

class AfterUninstall
{
    public function run(Container $container): void
    {
        // 1. Konfiguration bereinigen
        $configWriter = $container->get('injectableFactory')->create(ConfigWriter::class);
        $configWriter->set('shRecalculateEntityList', null);
        $configWriter->save();

        // 2. Modul-Ordner definieren
        $modulePath = 'custom/Espo/Modules/SHRecalculate';
        $clientPath = 'client/custom/modules/sh-recalculate';

        // 3. Rekursives Löschen ausführen
        $this->deleteDirectory($modulePath);
        $this->deleteDirectory($clientPath);

        // 4. Cache leeren
        try {
            $container->get('metadata')->flush();
        } catch (\Exception $e) {}
    }

    /**
     * Hilfsmethode zum rekursiven Löschen eines Ordners samt Inhalt
     */
    private function deleteDirectory(string $dir): bool
    {
        if (!file_exists($dir)) {
            return true;
        }

        if (!is_dir($dir)) {
            return unlink($dir);
        }

        foreach (scandir($dir) as $item) {
            if ($item == '.' || $item == '..') {
                continue;
            }

            if (!$this->deleteDirectory($dir . DIRECTORY_SEPARATOR . $item)) {
                return false;
            }
        }

        return rmdir($dir);
    }
}