<?php
use Espo\Core\Container;
use Espo\Core\InjectableFactory;
use Espo\Core\Utils\Config;
use Espo\Core\Utils\Config\ConfigWriter;
use Espo\Core\Utils\Rebuild;

class AfterInstall
{
    public function run(Container $container): void
    {
        $injectableFactory = $container->get('injectableFactory');
        $configWriter = $injectableFactory->create(ConfigWriter::class);

        // 1. Whitelist initialisieren
        $config = $container->get('config');
        if (!$config->has('shRecalculateEntityList')) {
            $configWriter->set('shRecalculateEntityList', []);
            $configWriter->save();
        }

        // 2. modulePaths in Custom/client.json sicherstellen
        $this->registerModulePath($container);

        // 3. System-Rebuild
        try {
            $rebuilder = $injectableFactory->create(Rebuild::class);
            $rebuilder->rebuild();
        } catch (\Exception $e) {}
    }

    private function registerModulePath(Container $container): void
    {
        $path = 'custom/Espo/Custom/Resources/metadata/app/client.json';
        $data = [];
        if (file_exists($path)) {
            $data = json_decode(file_get_contents($path), true) ?: [];
        }

        if (!isset($data['modulePaths'])) {
            $data['modulePaths'] = [];
        }

        // Pfad für unser JS registrieren
        $data['modulePaths']['sh-recalculate'] = 'client/custom/modules/sh-recalculate/src';

        file_put_contents($path, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
    }
}