<?php
namespace Espo\Modules\SHRecalculate\Services;

use Espo\Core\Templates\Services\Base;
use Espo\ORM\Entity;

class SHRecalculate extends Base
{
    /**
     * Berechnet die Formeln eines Datensatzes neu.
     * Wenn Relationen angegeben sind (optional), werden diese ebenfalls getriggert.
     */
    public function recalculateSingleEntity(string $entityType, string $id): bool
    {
        $entity = $this->getEntityManager()->getEntity($entityType, $id);

        if (!$entity) return false;

        if (!$this->getAcl()->checkEntity($entity, 'edit')) {
            throw new \Espo\Core\Exceptions\Forbidden();
        }

        // 1. Haupt-Entität neu berechnen
        $this->getEntityManager()->saveEntity($entity, ['forceRecalculate' => true]);

        // 2. Beispiel: Falls du spezifische Relationen hast, die immer mitberechnet werden sollen,
        // könnte man hier durch $entity->get('relationName') loopen.
        
        return true;
    }
}