<?php
namespace Espo\Modules\SHRecalculate\Controllers;

use Espo\Core\Api\Request;
use Espo\Core\Api\Response;

class RecalculateFormula extends \Espo\Core\Controllers\Base
{
    // NEU: Liefert die Liste der erlaubten Entitäten an das Frontend
    public function getActionEnabledEntities(Request $request, Response $response): array
    {
        $config = $this->getContainer()->get('config');
        // Holt die Liste direkt aus der config.php
        return $config->get('shRecalculateEntityList', []);
    }

    public function postActionRecalculateFormula(Request $request, Response $response)
    {
        $data = $request->getParsedBody();
        $id = $data->id ?? $data['id'] ?? null;
        $entityType = $data->entityType ?? $data['entityType'] ?? null;

        $entityManager = $this->getContainer()->get('entityManager');
        $entity = $entityManager->getEntity($entityType, $id);

        if ($entity) {
            $entityManager->saveEntity($entity, ['recalculateFormulas' => true]);
            return true;
        }
        return false;
    }
}