define('sh-recalculate:setup-handler', [], function () {
    return class {
        process(view) {
            if (!view.model || !view.scope || view.scope !== view.model.name) return;

            Espo.Ajax.getRequest('RecalculateFormula/action/enabledEntities')
                .then(enabledEntities => {
                    if (Array.isArray(enabledEntities) && enabledEntities.includes(view.scope)) {
                        this.injectButton(view);
                    }
                })
                .catch(err => console.error("SH-Recalculate: Fehler beim Laden der Config", err));
        }

        injectButton(view) {
            view.actionRecalculateFormula = () => this.runRecalculation(view);

            const inject = () => {
                const $header = view.$el.find('.header-buttons, .detail-buttons, .buttons-container, .panel-actions').first();
                if ($header.length && !$header.find('[data-name="recalculateFormula"]').length) {
                    const label = view.translate('recalculateFormula', 'labels', 'SHRecalculate');
                    $header.prepend(`
                        <button class="btn btn-danger action radius-left radius-Right" type="button" data-action="recalculateFormula" data-name="recalculateFormula" style="margin-right: 5px; font-weight: bold;">
                            <span class="label-text">${label && label !== 'recalculateFormula' ? label : 'Neuberechnen'}</span>
                        </button>
                    `);
                }
            };

            inject();
            // Nutze 'on' statt 'once', damit der Button bei jedem Re-Render erscheint
            view.on('after:render', inject);
            
            // Falls das Model synchronisiert wird (nach Save), Button erneut sicherstellen
            view.listenTo(view.model, 'sync', () => {
                setTimeout(inject, 100);
            });
        }

        runRecalculation(view) {
            Espo.Ui.notify(view.translate('recalculationInProgress', 'messages', 'SHRecalculate') || 'Berechne...');
            Espo.Ajax.postRequest('RecalculateFormula/action/recalculateFormula', {
                id: view.model.id,
                entityType: view.model.name
            }).then(() => {
                view.model.fetch().then(() => {
                    Espo.Ui.notify(false);
                    Espo.Ui.success(view.translate('recalculationSuccess', 'messages', 'SHRecalculate') || 'Erfolgreich');
                });
            });
        }
    };
});