define('whatsapp:views/fields/whatsapp', ['views/fields/varchar'], (Dep) => {
    return class extends Dep {
        type = 'whatsapp'
        editTemplate = 'whatsapp:fields/whatsapp/edit'
        detailTemplate = 'whatsapp:fields/whatsapp/detail'
        listTemplate = 'whatsapp:fields/whatsapp/detail'

        setup() {
            super.setup();
            this.listenTo(this.model, 'change:' + this.name, () => {
                this.reRender();
            });
        }

        data() {
            const value = this.model.get(this.name);
            let whatsappUrl = '';
            if (value) {
                // Remove all non-numeric characters
                const cleanNumber = value.replace(/\D/g, '');
                whatsappUrl = 'https://wa.me/' + cleanNumber;
            }

            return _.extend({
                whatsappUrl: whatsappUrl,
                hasValue: !!value
            }, super.data());
        }
    };
});
