Espo.define('lark-show-all-fields:views/record/show-all-fields', 'views/modal', function (Dep) {
    return Dep.extend({

        template: 'lark-show-all-fields:modals/show-all-fields',
        events: {
            'click a.sort': 'onSortClick',
            'click input': 'onOnlyValuesClick'
        },

        onOnlyValuesClick: function (e) {
            var $i = $(e.currentTarget);
            this.onlyValues = $i.is(':checked');
            this.render();
        },

        onSortClick: function (e) {
            var $a = $(e.currentTarget);
            var field = $a.data('sort');

            if (this.sortField === field) {
                this.sortDirection = this.sortDirection === 'asc' ? 'desc' : 'asc';
            } else {
                this.sortField = field;
                this.sortDirection = 'desc';
            }

            this.render();
        },

        data() {
            const self = this;
            const d = [];
            for (const [fieldName, fieldDef] of this.fieldEntries) {
                const fieldType = fieldDef.type || 'base';
                const fieldLabel = this.translate(fieldName, 'fields', this.options.model.name);
                let rawValue = this.fieldAttributes[fieldType == "link" ? fieldName+"Name" : fieldName];
                if (this.onlyValues && (rawValue === null || rawValue === '' || typeof rawValue === 'undefined')) {
                    continue;
                }
                if (fieldName == "teams")
                    rawValue = this.options.model.getTeamIdList();
                else if (fieldType == "linkMultiple")
                    rawValue = this.options.model.getLinkMultipleIdList(fieldName);

                d.push({name: fieldName, label: fieldLabel, type: fieldType, value: rawValue});
            }

            var sorted = _.sortBy(d || [], function (item) {
                var v = self.sortField == 'label' ? item.label : item.name;

                if (v === null || typeof v === 'undefined') return '';
                if (_.isNumber(v)) return v;
                return String(v).toLowerCase();
            });

            if (this.sortDirection === 'desc') sorted.reverse();

            return {fields: sorted, sortUp: this.sortDirection === 'asc', sortLabel: this.sortField == 'label', onlyValues: this.onlyValues};
        },
        setup() {
            const entityType = this.options.model.name;
            const fields = this.getMetadata().get(['entityDefs', entityType, 'fields']) || {};
            this.fieldAttributes = this.options.model.attributes;

            this.fieldEntries = Object.entries(fields).sort(([a], [b]) => a.localeCompare(b));
            this.sortDirection = 'asc';
            this.sortLabel = false;

            this.buttonList = [
                {
                    name: 'close',
                    text: "Close",
                    style: 'primary',
                    onClick: () => this.close(),
                }
            ];
        }
    });
});