Espo.define('lark-show-all-fields:views/record/show-all-fields', 'views/modal', function (Dep) {
    return Dep.extend({

        template: 'lark-show-all-fields:modals/show-all-fields',

        data() {
            const d = [];
            for (const [fieldName, fieldDef] of this.fieldEntries) {
                const fieldType = fieldDef.type || 'base';
                const fieldLabel = this.translate(fieldName, 'fields', this.options.model.name);
                let rawValue = this.fieldAttributes[fieldType == "link" ? fieldName+"Name" : fieldName];
                if (fieldName == "teams")
                    rawValue = this.options.model.getTeamIdList();
                else if (fieldType == "linkMultiple")
                    rawValue = this.options.model.getLinkMultipleIdList(fieldName);

                d.push({name: fieldName, label: fieldLabel, type: fieldType, value: rawValue});
            }
            return {fields: d};
        },
        setup() {
            const entityType = this.options.model.name;
            const fields = this.getMetadata().get(['entityDefs', entityType, 'fields']) || {};
            this.fieldAttributes = this.options.model.attributes;

            this.fieldEntries = Object.entries(fields).sort(([a], [b]) => a.localeCompare(b));

            this.buttonList = [
                {
                    name: 'close',
                    text: "Close",
                    style: 'primary',
                    onClick: () => this.close(),
                }
            ];
        }
    });
});