Espo.define(['view'], function (Dep) {
    return Dep.extend({

        templateContent: '<a style="color:rgb(180,106,102)" role="button" title="Rebuild and Reload"><span class="icon fas fa-wrench"></span></a>',

        setup: function () {
            const self = this;
            Dep.prototype.setup.call(this);
            this.addActionHandler('maintenance', (e, element) => {
                e.preventDefault();
                self.doMaintenance();
            }); 
        },

        events: {
            'click a': 'onClick',
            'dblclick a': 'onDblClick'
        },

        onClick: function (e) {
            clearTimeout(this.clickTimeout);

            this.clickTimeout = setTimeout(() => {
                this.doMaintenance();
                }, 250);
        },

        onDblClick: function (e) {
            clearTimeout(this.clickTimeout);
            this.openEntityManager();
        },

        afterRender: function () {
            Dep.prototype.afterRender.call(this);
            if (!this.getUser().isAdmin())
            {
                this.$el.hide();
                return;
            }
        },

        doMaintenance: function () {
            Espo.Ui.notify('Running maintenance…', 'neutral');

            Espo.Ajax.postRequest('Admin/rebuild')
                .then(() => {
                    window.location.reload(true);
                    Espo.Ui.notify('Maintenance completed successfully.', 'success');
                })
                .catch((err) => {
                    Espo.Ui.notify('Error during rebuild: ' + err.message, 'error');
                });
        },

        openEntityManager: function() {
            this.getRouter().navigate("#Admin/entityManager", {trigger: true});
        }
    });
});