<?php

namespace Espo\Custom\ServiceActions;

use Espo\ORM\Entity;
use Espo\Modules\Advanced\Tools\Workflow\Action\RunAction\ServiceAction;
// use Espo\Custom\CloudMail\CloudMail_Office365;


//// Either of these work

// require_once('/var/www/html/callback/custom/Espo/Custom/CloudMail/cloudmail_office365.php');
// require_once('/var/www/html/callback/custom/Espo/Custom/CloudMail/cloudmail_const.php');

require_once('custom/Espo/Custom/CloudMail/cloudmail_office365.php');
require_once('custom/Espo/Custom/CloudMail/cloudmail_const.php');

//// These do not work

// require_once('../CloudMail/cloudmail_office365.php');
// require_once('../CloudMail/cloudmail_const.php');

// require_once('Espo/Custom/CloudMail/cloudmail_office365.php');
// require_once('Espo/Custom/CloudMail/cloudmail_const.php');

class RenewalReminderServiceAction implements ServiceAction
{

  private $RTL                  = "";
  private $RefreshTokenFilePath = "refresh.txt";
  private $AuthScopes           = "user.read mail.readwrite mail.send mailboxsettings.readwrite";
  private $LogFilePath          = "/var/www/html/<install>/custom/Espo/Custom/ServiceActions/renewal_reminder.log";
  private $ClientId             = "";
  private $ClientSecret         = "";
  private $MessageTo            = "";

  public function run (Entity $entity, mixed $data): mixed
  {

    try {
      $this->doCreateDraft();
      // $this->doSanityCheck();
      $LogFile = fopen($this->LogFilePath, "a");
      fwrite($LogFile, "This is a test message.\n");
      fclose($LogFile);
    }
    catch (Exception $e) {
      $LogFile = fopen($this->LogFilePath, "a");
      fwrite($LogFile, $e->getMessage());
      fwrite($LogFile, $e->getTraceAsString());
      fclose($LogFile);
    }

    return null;
  }

  private function doSanityCheck()
  {
    $command = "touch /home/www-data/hello-service-sanity.txt";
    $output = null;
    $retval = null;
    exec($command, $output, $retval);
  }

  // private function doBuildXML()
  // {
  //   // TBD
  // }

  private function doCreateDraft()
  {
    $Mail = new CloudMail_Office365();
    $Mail->setRuntimeLicense($this->RTL);
    $Mail->setOAuthClientId($this->ClientId);
    $Mail->setOAuthClientSecret($this->ClientSecret);
    // $Mail->setOAuthGrantType(0); // OFFICE365_OAUTHGRANTTYPE_AUTHORIZATION_CODE(0), default
    // $Mail->setOAuthClientProfile(0); // OFFICE365_OAUTHCLIENTPROFILE_APPLICATION(0), default
    $Mail->setOAuthRefreshToken($this->getRefreshToken());
    $Mail->setOAuthAuthorizationScope($this->AuthScopes);

    $Mail->doAuthorize();
    $RefreshTokenFile = fopen($this->RefreshTokenFilePath, "w");
    fwrite($RefreshTokenFile, $Mail->getOAuthRefreshToken());
    fclose($RefreshTokenFile);

    $XML = "<mytest>sum data</mytest>";
    $Mail->setMessageSubject("Renewal Reminder Test");
    $Mail->setMessageBodyContent($XML);
    $Mail->setMessageTo($this->MessageTo);
    $Mail->doCreateDraft(0, ""); // 0=MESSAGE (a new draft)


    // List Folders test
    // $Mail->doListFolders("");
    // for ($index = 0; $index < $Mail->getFolderCount(); $index++) {
    //   $FolderName = $Mail->getFolderDisplayName($index);
    //   $FolderId = $Mail->getFolderId($index);
    //   echo "$FolderName -- $FolderId\n";
    // }
  }

  private function getRefreshToken() {
    $RefreshToken = "";
    $RefreshTokenFile = fopen($this->RefreshTokenFilePath, "r");
    $RefreshToken = fread($RefreshTokenFile, filesize($this->RefreshTokenFilePath));
    fclose($RefreshTokenFile);
    return $RefreshToken;
  }

}

?>