<?php
namespace Espo\Modules\ThreadedComments\Scripts;

use Espo\Core\Container;
use Espo\Core\Utils\Metadata;
use Espo\Core\Utils\Config;

class AfterUninstall
{
    public function run(Container $container)
    {
        $metadata = $container->get('metadata');
        $config = $container->get('config');

        // Disable comments for all entities
        $this->disableCommentsForAllEntities($metadata);
    }

    protected function disableCommentsForAllEntities(Metadata $metadata)
    {
        $scopes = $metadata->get('scopes', []);
        
        foreach ($scopes as $scope => $data) {
            if (isset($data['comments'])) {
                $metadata->set('scopes', $scope, [
                    'comments' => false
                ]);
            }
        }

        $metadata->save();
    }
} 