<?php
namespace Espo\Modules\ThreadedComments\Scripts;

use Espo\Core\Container;
use Espo\Core\Utils\Metadata;
use Espo\Core\Utils\Config;

class AfterInstall
{
    public function run(Container $container)
    {
        $metadata = $container->get('metadata');
        $config = $container->get('config');

        // Enable comments for Account and Contact entities by default
        $this->enableCommentsForEntities(['Account', 'Contact'], $metadata);
    }

    protected function enableCommentsForEntities(array $entities, Metadata $metadata)
    {
        foreach ($entities as $entity) {
            $metadata->set('scopes', $entity, [
                'comments' => true
            ]);
        }

        $metadata->save();
    }
} 