Espo.define('threaded-comments:collections/comment', ['collection'], function (Dep) {
    return Dep.extend({
        url: function () {
            return this.parentEntity.name + '/' + this.parentEntity.id + '/comments';
        },
        
        fetchNew: function (options) {
            options = options || {};
            options.data = options.data || {};
            options.data.maxSize = this.maxSize;
            options.data.offset = this.length;
            
            return Dep.prototype.fetch.call(this, options);
        }
    });
});

Espo.define('threaded-comments:views/comments/panel', ['views/stream/panel'], function (Dep) {
    return Dep.extend({
        template: 'threaded-comments:comments/panel',
        
        setup: function () {
            this.collection = this.getCollection();
            this.collection.maxSize = this.getConfig().get('recordsPerPage') || 20;
            
            this.collection.parentEntity = this.model;
            
            this.collection.on('sync', function () {
                this.render();
            }, this);
            
            this.collection.fetch();
        },
        
        getCollection: function () {
            return this.collectionFactory.create('threaded-comments:collections/comment');
        },
        
        actionPost: function () {
            var post = this.$el.find('.post-field').val().trim();
            if (!post) return;
            
            var model = this.collection.create();
            model.set({
                post: post,
                parentId: this.model.id,
                parentType: this.model.name
            });
            
            model.save().then(function () {
                this.$el.find('.post-field').val('');
                this.collection.fetch();
            }.bind(this));
        }
    });
});

Espo.define('threaded-comments:views/comments/comment', ['views/stream/note'], function (Dep) {
    return Dep.extend({
        template: 'threaded-comments:comments/comment',
        
        setup: function () {
            this.fields = ['post', 'attachments', 'createdAt'];
            this.rowActionsView = 'threaded-comments:views/comments/row-actions/default';
        },
        
        actionQuickReply: function () {
            this.$el.find('.threaded-comment-reply-form').addClass('active');
            this.$el.find('.post-field').focus();
        },
        
        actionPostReply: function () {
            var post = this.$el.find('.post-field').val().trim();
            if (!post) return;
            
            var model = this.collection.create();
            model.set({
                post: post,
                parentId: this.model.get('parentId'),
                parentType: this.model.get('parentType'),
                commentReplyId: this.model.id,
                threadId: this.model.get('threadId') || this.model.id
            });
            
            model.save().then(function () {
                this.$el.find('.post-field').val('');
                this.$el.find('.threaded-comment-reply-form').removeClass('active');
                this.actionLoadReplies();
            }.bind(this));
        },
        
        actionLoadReplies: function () {
            var threadId = this.model.get('threadId') || this.model.id;
            
            this.ajaxGetRequest('Comment/action/commentThreadTree', {
                threadId: threadId
            }).then(function (data) {
                this.renderReplies(data);
            }.bind(this));
        },
        
        renderReplies: function (data) {
            var $replies = this.$el.find('.threaded-comment-replies');
            $replies.empty();
            
            data.forEach(function (item) {
                var view = this.getView('comment', 'threaded-comments:views/comments/comment', {
                    model: this.collection.create(item),
                    collection: this.collection
                });
                
                view.render();
                $replies.append(view.$el);
            }, this);
        }
    });
});

Espo.define('threaded-comments:views/comments/row-actions/default', ['views/stream/row-actions/default'], function (Dep) {
    return Dep.extend({
        getActionList: function () {
            return [
                {
                    action: 'quickReply',
                    label: 'Reply',
                    data: {
                        id: this.model.id
                    }
                }
            ];
        }
    });
}); 