Espo.define('threaded-comments:extensions/views/record/detail-bottom', ['view'], function (Dep) {
    return Dep.extend({
        setup: function () {
            this.listenTo(this.model, 'change', function () {
                if (this.model.hasChanged('id')) {
                    this.reRender();
                }
            }, this);
        },

        afterRender: function () {
            if (this.getMetadata().get(['scopes', this.model.name, 'comments'])) {
                this.createView('comments', 'threaded-comments:views/comments/panel', {
                    model: this.model,
                    el: this.options.el + ' .threaded-comments-panel'
                });
            }
        }
    });
}); 