Espo.define('threaded-comments:extensions/views/admin/entity-manager/edit', ['view'], function (Dep) {
    return Dep.extend({
        setup: function () {
            this.listenTo(this.model, 'change', function () {
                if (this.model.hasChanged('id')) {
                    this.reRender();
                }
            }, this);
        },

        afterRender: function () {
            if (this.getMetadata().get(['scopes', this.model.get('name'), 'stream'])) {
                var $field = this.$el.find('.field[data-name="comments"]');
                
                if ($field.length) {
                    return;
                }

                var $row = $('<div class="row">').appendTo(this.$el.find('.fields-container'));
                var $cell = $('<div class="cell col-md-6">').appendTo($row);
                
                $field = $('<div class="field" data-name="comments">').appendTo($cell);
                
                $field.append(
                    '<div class="form-group">' +
                        '<label class="control-label">' + this.translate('Comments', 'fields', 'EntityManager') + '</label>' +
                        '<div class="field">' +
                            '<select class="form-control" data-name="comments">' +
                                '<option value="true">' + this.translate('Yes') + '</option>' +
                                '<option value="false">' + this.translate('No') + '</option>' +
                            '</select>' +
                        '</div>' +
                    '</div>'
                );

                var commentsEnabled = this.getMetadata().get(['scopes', this.model.get('name'), 'comments']) || false;
                
                $field.find('select').val(commentsEnabled ? 'true' : 'false');
            }
        },

        actionSave: function () {
            var commentsEnabled = this.$el.find('select[data-name="comments"]').val() === 'true';
            
            this.ajaxPostRequest('EntityManager/action/toggleComments', {
                scope: this.model.get('name'),
                commentsEnabled: commentsEnabled
            });

            Dep.prototype.actionSave.call(this);
        }
    });
}); 