<div class="threaded-comment" data-id="{{id}}">
    <div class="threaded-comment-content">
        {{{post}}}
    </div>
    
    {{#if attachments.length}}
    <div class="threaded-comment-attachments">
        {{#each attachments}}
        <div class="threaded-comment-attachment">
            <a href="{{url}}" target="_blank">{{name}}</a>
        </div>
        {{/each}}
    </div>
    {{/if}}
    
    <div class="threaded-comment-meta">
        <span class="text-muted">{{{createdAt}}}</span>
        <span class="text-muted">by {{{createdBy}}}</span>
    </div>
    
    <div class="threaded-comment-actions">
        <button class="btn btn-link btn-sm action-reply" data-action="quickReply">
            {{translate 'Reply' scope='Comment'}}
        </button>
        {{#if hasChildren}}
        <button class="btn btn-link btn-sm action-load-replies" data-action="loadReplies">
            {{translate 'Load Replies' scope='Comment'}}
        </button>
        {{/if}}
    </div>
    
    <div class="threaded-comment-reply-form" style="display: none;">
        <div class="input-group">
            <textarea class="form-control post-field" rows="3" placeholder="{{translate 'Write a reply...' scope='Comment'}}"></textarea>
            <div class="input-group-btn">
                <button class="btn btn-default post-button" type="button">
                    {{translate 'Post' scope='Comment'}}
                </button>
            </div>
        </div>
    </div>
    
    <div class="threaded-comment-replies"></div>
</div> 