<?php
namespace Espo\Modules\ThreadedComments\Repositories;

use Espo\Core\Templates\Repositories\Base;
use Espo\ORM\Entity;

class Comment extends Base
{
    protected function afterRemove(Entity $entity, array $options = [])
    {
        parent::afterRemove($entity, $options);

        $this->deleteChildren($entity);
    }

    protected function deleteChildren(Entity $entity): void
    {
        $children = $this->where([
            'commentReplyId' => $entity->id
        ])->find();

        foreach ($children as $child) {
            $this->remove($child);
        }
    }
} 