<?php
namespace Espo\Modules\ThreadedComments\Controllers;

use Espo\Core\Controllers\Record;
use Espo\Core\Exceptions\BadRequest;
use Espo\Core\Exceptions\Forbidden;

class EntityManager extends Record
{
    public function postActionToggleComments($params, $data, $request)
    {
        if (!$this->user->isAdmin()) {
            throw new Forbidden();
        }

        if (!isset($data->scope) || !isset($data->commentsEnabled)) {
            throw new BadRequest();
        }

        $scope = $data->scope;
        $commentsEnabled = $data->commentsEnabled;

        $this->getMetadata()->set('scopes', $scope, [
            'comments' => $commentsEnabled
        ]);

        $this->getMetadata()->save();

        return true;
    }
} 