<?php
namespace Espo\Modules\ThreadedComments\Controllers;

use Espo\Core\Templates\Controllers\Base;
use Espo\Core\Api\Request;
use Espo\Core\Api\Response;
use Espo\Core\Exceptions\BadRequest;
use Espo\Core\Exceptions\Forbidden;
use Espo\Core\Exceptions\NotFound;

class Comment extends Base
{
    public function getActionListForEntity(Request $request, Response $response): array
    {
        $scope = $request->getRouteParam('scope');
        $id = $request->getRouteParam('id');

        if (!$scope || !$id) {
            throw new BadRequest();
        }

        $searchParams = $this->searchParamsFetcher->fetch($request);

        $collection = $this->getService('Comment')->findForEntity($scope, $id, $searchParams);

        return [
            'total' => $collection->count(),
            'list' => $collection->getValueMapList()
        ];
    }

    public function getActionCommentThreadTree(Request $request, Response $response): array
    {
        $threadId = $request->getQueryParam('threadId');

        if (!$threadId) {
            throw new BadRequest();
        }

        return $this->getService('Comment')->getCommentThreadTree($threadId);
    }
} 