<?php
namespace Espo\Modules\ThreadedComments\Classes\Acl\Comment;

use Espo\Core\Acl\AccessEntityCREDSChecker;
use Espo\Core\Acl\DefaultAccessChecker;
use Espo\Core\AclManager;
use Espo\Core\ORM\EntityManager;
use Espo\Entities\User;
use Espo\ORM\Entity;

class AccessChecker implements AccessEntityCREDSChecker
{
    private $defaultChecker;
    private $aclManager;
    private $entityManager;

    public function __construct(
        DefaultAccessChecker $defaultChecker,
        AclManager $aclManager,
        EntityManager $entityManager
    ) {
        $this->defaultChecker = $defaultChecker;
        $this->aclManager = $aclManager;
        $this->entityManager = $entityManager;
    }

    public function check(User $user, Entity $entity): bool
    {
        return $this->defaultChecker->check($user, $entity);
    }

    public function checkCreate(User $user, Entity $entity): bool
    {
        $parentType = $entity->get('parentType');
        $parentId = $entity->get('parentId');

        if (!$parentType || !$parentId) {
            return false;
        }

        $parent = $this->entityManager->getEntity($parentType, $parentId);

        if (!$parent) {
            return false;
        }

        return $this->aclManager->checkStream($user, $parent);
    }

    public function checkRead(User $user, Entity $entity): bool
    {
        $parentType = $entity->get('parentType');
        $parentId = $entity->get('parentId');

        if (!$parentType || !$parentId) {
            return false;
        }

        $parent = $this->entityManager->getEntity($parentType, $parentId);

        if (!$parent) {
            return false;
        }

        return $this->aclManager->checkStream($user, $parent);
    }

    public function checkEdit(User $user, Entity $entity): bool
    {
        if ($entity->get('createdById') !== $user->getId()) {
            return false;
        }

        return $this->checkRead($user, $entity);
    }

    public function checkDelete(User $user, Entity $entity): bool
    {
        if ($entity->get('createdById') !== $user->getId()) {
            return false;
        }

        return $this->checkRead($user, $entity);
    }

    public function checkStream(User $user, Entity $entity): bool
    {
        return $this->checkRead($user, $entity);
    }
} 